/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.commands;

import com.github.rvesse.airline.HelpOption;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.annotations.restrictions.MutuallyExclusiveWith;
import com.github.rvesse.airline.annotations.restrictions.Once;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.apache.logging.log4j.Logger;

public abstract class BaseCommand
implements Runnable {
    private static final String CONFIG_FILE_OPTION = "--config-file";
    private static final String CONFIG_FILE_OPTION_SHORT = "-c";
    @Inject
    protected HelpOption<BaseCommand> help;
    @Option(name={"-c", "--config-file"}, title="config-file", description="Path to migrations configuration file. Required for all commands with the exception of `new-project`.", type=OptionType.GLOBAL)
    @MutuallyExclusiveWith(tag="config")
    @Once
    protected String configFileGlobal;
    @Option(name={"-c", "--config-file"}, title="config-file", description="Path to migrations configuration file. Required for all commands with the exception of `new-project`.", type=OptionType.COMMAND, hidden=true)
    @MutuallyExclusiveWith(tag="config")
    @Once
    protected String configFileNonGlobal;

    @Override
    public void run() {
        this.runCommand();
    }

    public int runCommand() {
        if (this.help.showHelpIfRequested()) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        int status = this.command();
        this.getLogger().info(String.format("Execution time: %.4f seconds", (double)(System.currentTimeMillis() - startTime) / 1000.0));
        return status;
    }

    protected abstract int command();

    protected abstract Logger getLogger();

    protected String getConfigFile() {
        if (this.configFileGlobal != null) {
            return this.configFileGlobal;
        }
        if (this.configFileNonGlobal != null) {
            return this.configFileNonGlobal;
        }
        return null;
    }

    protected boolean validateConfigFilePresent() {
        if (this.getConfigFile() == null || this.getConfigFile().trim().equals("")) {
            this.getLogger().error("Migrations config file required but not specified. Specify with {} (or, equivalently, {}).", (Object)CONFIG_FILE_OPTION, (Object)CONFIG_FILE_OPTION_SHORT);
            return false;
        }
        return true;
    }

    protected boolean validateMetadataInitialized(Client ksqlClient, MigrationConfig config) {
        String streamName = config.getString("ksql.migrations.stream.name");
        String tableName = config.getString("ksql.migrations.table.name");
        return this.describeSource(ksqlClient, streamName, "stream") && this.describeSource(ksqlClient, tableName, "table");
    }

    private boolean describeSource(Client ksqlClient, String sourceName, String type) {
        try {
            ksqlClient.describeSource(sourceName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLogger().error(String.format("Failed to verify existence of migrations metadata %s '%s'. Did you run `%s %s`? Error message: %s", type, sourceName, "ksql-migrations", "initialize-metadata", e.getMessage()));
            return false;
        }
        return true;
    }
}

