/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.util;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.expression.tree.BooleanLiteral;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.expression.tree.StringLiteral;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.VariableSubstitutor;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.tools.migrations.MigrationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;

public final class CommandParser {
    private static final KsqlParser KSQL_PARSER = new DefaultKsqlParser();
    private static final String SELECT = "SELECT";
    private static final String DESCRIBE = "DESCRIBE";
    private static final String EXPLAIN = "EXPLAIN";
    private static final String PRINT = "PRINT";
    private static final String SHOW = "SHOW";
    private static final String LIST = "LIST";
    private static final String RUN = "RUN";
    private static final String SCRIPT = "SCRIPT";
    private static final String SHORT_COMMENT_OPENER = "--";
    private static final String SHORT_COMMENT_CLOSER = "\n";
    private static final String LONG_COMMENT_OPENER = "/*";
    private static final String LONG_COMMENT_CLOSER = "*/";
    private static final char SINGLE_QUOTE = '\'';
    private static final char SEMICOLON = ';';
    private static final List<String> UNSUPPORTED_STATEMENTS = ImmutableList.of((Object)"DESCRIBE", (Object)"EXPLAIN", (Object)"SELECT", (Object)"PRINT", (Object)"SHOW", (Object)"LIST");

    private CommandParser() {
    }

    public static List<String> splitSql(String sql) {
        ArrayList<String> commands = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int index = 0;
        while (index < sql.length()) {
            if (sql.charAt(index) == '\'') {
                int closingToken = sql.indexOf(39, index + 1);
                CommandParser.validateToken(String.valueOf('\''), closingToken);
                current.append(sql, index, closingToken + 1);
                index = closingToken + 1;
                continue;
            }
            if (index < sql.length() - 1 && sql.startsWith(SHORT_COMMENT_OPENER, index)) {
                index = sql.indexOf(SHORT_COMMENT_CLOSER, index + 1) + 1;
                CommandParser.validateToken(SHORT_COMMENT_CLOSER, index - 1);
                continue;
            }
            if (index < sql.length() - 1 && sql.startsWith(LONG_COMMENT_OPENER, index)) {
                index = sql.indexOf(LONG_COMMENT_CLOSER, index + 1) + 2;
                CommandParser.validateToken(LONG_COMMENT_CLOSER, index - 2);
                continue;
            }
            if (sql.charAt(index) == ';') {
                current.append(';');
                commands.add(current.toString());
                current = new StringBuilder();
                ++index;
                continue;
            }
            current.append(sql.charAt(index));
            ++index;
        }
        if (!current.toString().trim().isEmpty()) {
            throw new MigrationException(String.format("Unmatched command at end of file; missing semicolon: '%s'", current));
        }
        return commands;
    }

    private static void validateToken(String token, int index) {
        if (index < 0) {
            throw new MigrationException("Invalid sql - failed to find closing token '" + token + "'");
        }
    }

    public static Object toFieldType(Expression expressionValue) {
        if (expressionValue instanceof StringLiteral) {
            return ((StringLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof IntegerLiteral) {
            return ((IntegerLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof LongLiteral) {
            return ((LongLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof DoubleLiteral) {
            return ((DoubleLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof BooleanLiteral) {
            return ((BooleanLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof DecimalLiteral) {
            return ((DecimalLiteral)expressionValue).getValue();
        }
        if (expressionValue instanceof NullLiteral) {
            return null;
        }
        if (expressionValue instanceof CreateArrayExpression) {
            return ((CreateArrayExpression)expressionValue).getValues().stream().map(CommandParser::toFieldType).collect(Collectors.toList());
        }
        if (expressionValue instanceof CreateMapExpression) {
            HashMap resolvedMap = new HashMap();
            ((CreateMapExpression)expressionValue).getMap().forEach((k, v) -> resolvedMap.put(CommandParser.toFieldType(k), CommandParser.toFieldType(v)));
            return resolvedMap;
        }
        if (expressionValue instanceof CreateStructExpression) {
            HashMap resolvedStruct = new HashMap();
            ((CreateStructExpression)expressionValue).getFields().forEach(field -> resolvedStruct.put(field.getName(), CommandParser.toFieldType(field.getValue())));
            return resolvedStruct;
        }
        throw new IllegalStateException("Expression type not recognized: " + expressionValue.toString());
    }

    public static ParsedCommand parse(String sql, Map<String, String> variables) {
        String substituted;
        CommandParser.validateSupportedStatementType(sql);
        try {
            substituted = VariableSubstitutor.substitute((KsqlParser.ParsedStatement)((KsqlParser.ParsedStatement)KSQL_PARSER.parse(sql).get(0)), variables);
        }
        catch (ParseFailedException e) {
            throw new MigrationException(String.format("Failed to parse the statement. Statement: %s. Reason: %s", sql, e.getMessage()));
        }
        SqlBaseParser.SingleStatementContext statementContext = ((KsqlParser.ParsedStatement)KSQL_PARSER.parse(substituted).get(0)).getStatement();
        boolean isStatement = StatementType.get(statementContext.statement().getClass()) == StatementType.STATEMENT;
        return new ParsedCommand(substituted, isStatement ? Optional.empty() : Optional.of(new AstBuilder(TypeRegistry.EMPTY).buildStatement((ParserRuleContext)statementContext)));
    }

    private static void validateSupportedStatementType(String sql) {
        List tokens = Arrays.stream(sql.toUpperCase().split("\\s+")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (tokens.size() > 0 && UNSUPPORTED_STATEMENTS.contains(tokens.get(0))) {
            throw new MigrationException("'" + (String)tokens.get(0) + "' statements are not supported.");
        }
        if (tokens.size() > 1 && ((String)tokens.get(0)).equals(RUN) && ((String)tokens.get(1)).equals(SCRIPT)) {
            throw new MigrationException("'RUN SCRIPT' statements are not supported.");
        }
    }

    public static String preserveCase(String fieldOrSourceName) {
        return "`" + fieldOrSourceName + "`";
    }

    private static enum StatementType {
        INSERT_VALUES(SqlBaseParser.InsertValuesContext.class),
        CREATE_CONNECTOR(SqlBaseParser.CreateConnectorContext.class),
        DROP_CONNECTOR(SqlBaseParser.DropConnectorContext.class),
        STATEMENT(SqlBaseParser.StatementContext.class),
        SET_PROPERTY(SqlBaseParser.SetPropertyContext.class),
        UNSET_PROPERTY(SqlBaseParser.UnsetPropertyContext.class),
        DEFINE_VARIABLE(SqlBaseParser.DefineVariableContext.class),
        UNDEFINE_VARIABLE(SqlBaseParser.UndefineVariableContext.class),
        ASSERT_TOPIC(SqlBaseParser.AssertTopicContext.class),
        ASSERT_SCHEMA(SqlBaseParser.AssertSchemaContext.class);

        private final Class<? extends SqlBaseParser.StatementContext> statementClass;

        private <T extends SqlBaseParser.StatementContext> StatementType(Class<T> statementClass) {
            this.statementClass = Objects.requireNonNull(statementClass, "statementType");
        }

        public static StatementType get(Class<? extends SqlBaseParser.StatementContext> statementClass) {
            Optional<StatementType> type = Arrays.stream(StatementType.values()).filter(statementType -> statementType.statementClass.equals(statementClass)).findFirst();
            return type.orElse(STATEMENT);
        }
    }

    public static class ParsedCommand {
        private final String command;
        private final Optional<Statement> statement;

        ParsedCommand(String command, Optional<Statement> statement) {
            this.command = command;
            this.statement = statement;
        }

        public String getCommand() {
            return this.command;
        }

        public Optional<Statement> getStatement() {
            return this.statement;
        }
    }
}

