/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.util;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.api.client.BatchedQueryResult;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.KsqlArray;
import io.confluent.ksql.api.client.KsqlObject;
import io.confluent.ksql.api.client.Row;
import io.confluent.ksql.api.client.ServerInfo;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.tools.migrations.util.MigrationFile;
import io.confluent.ksql.tools.migrations.util.MigrationVersionInfo;
import io.confluent.ksql.tools.migrations.util.ServerVersionUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public final class MetadataUtil {
    public static final String NONE_VERSION = "<none>";
    public static final String CURRENT_VERSION_KEY = "CURRENT";
    public static final String EMPTY_ERROR_REASON = "N/A";
    private static final List<String> KEYS = ImmutableList.of((Object)"VERSION_KEY", (Object)"VERSION", (Object)"NAME", (Object)"STATE", (Object)"CHECKSUM", (Object)"STARTED_ON", (Object)"COMPLETED_ON", (Object)"PREVIOUS", (Object)"ERROR_REASON");

    private MetadataUtil() {
    }

    public static String getCurrentVersion(MigrationConfig config, Client client) {
        String migrationTableName = config.getString("ksql.migrations.table.name");
        BatchedQueryResult result = client.executeQuery("SELECT VERSION FROM " + migrationTableName + " WHERE version_key = 'CURRENT';");
        try {
            List resultRows = (List)result.get();
            if (resultRows.size() == 0) {
                return NONE_VERSION;
            }
            return ((Row)resultRows.get(0)).getString("VERSION");
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MigrationException(String.format("Could not query %s: %s", migrationTableName, e.getMessage()));
        }
    }

    public static CompletableFuture<Void> writeRow(MigrationConfig config, Client client, String versionKey, String state, String startOn, String completedOn, MigrationFile migration, String previous, String checksum, Optional<String> errorReason) {
        String migrationStreamName = config.getString("ksql.migrations.stream.name");
        ImmutableList values = ImmutableList.of((Object)versionKey, (Object)Integer.toString(migration.getVersion()), (Object)migration.getName(), (Object)state, (Object)checksum, (Object)startOn, (Object)completedOn, (Object)previous, (Object)errorReason.orElse(EMPTY_ERROR_REASON));
        return client.insertInto(migrationStreamName, KsqlObject.fromArray(KEYS, (KsqlArray)new KsqlArray((List)values)));
    }

    public static String getLatestMigratedVersion(MigrationConfig config, Client ksqlClient) {
        String currentVersion = MetadataUtil.getCurrentVersion(config, ksqlClient);
        if (currentVersion.equals(NONE_VERSION)) {
            return currentVersion;
        }
        MigrationVersionInfo currentVersionInfo = MetadataUtil.getInfoForVersion(currentVersion, config, ksqlClient);
        if (currentVersionInfo.getState() == MigrationState.MIGRATED) {
            return currentVersion;
        }
        if (currentVersionInfo.getPrevVersion().equals(NONE_VERSION)) {
            return NONE_VERSION;
        }
        MigrationVersionInfo prevVersionInfo = MetadataUtil.getInfoForVersion(currentVersionInfo.getPrevVersion(), config, ksqlClient);
        MetadataUtil.validateVersionIsMigrated(currentVersionInfo.getPrevVersion(), prevVersionInfo, currentVersion);
        return currentVersionInfo.getPrevVersion();
    }

    public static void validateVersionIsMigrated(String version, MigrationVersionInfo versionInfo, String nextVersion) {
        if (versionInfo.getState() != MigrationState.MIGRATED) {
            throw new MigrationException(String.format("Discovered version with previous version that does not have status %s. Version: %s. Previous version: %s. Previous version status: %s", new Object[]{MigrationState.MIGRATED, nextVersion, version, versionInfo.getState()}));
        }
    }

    public static MigrationVersionInfo getInfoForVersion(String version, MigrationConfig config, Client ksqlClient) {
        Optional<MigrationVersionInfo> maybeInfo = MetadataUtil.getOptionalInfoForVersion(version, config, ksqlClient);
        return maybeInfo.orElseThrow(() -> new MigrationException("Failed to query state for migration with version " + version + ": no such migration is present in the migrations metadata table"));
    }

    public static Optional<MigrationVersionInfo> getOptionalInfoForVersion(String version, MigrationConfig config, Client ksqlClient) {
        Row resultRow;
        String migrationTableName = config.getString("ksql.migrations.table.name");
        BatchedQueryResult result = ksqlClient.executeQuery("SELECT version, checksum, previous, state, name, started_on, completed_on, error_reason FROM " + migrationTableName + " WHERE version_key = '" + version + "';");
        try {
            List resultRows = (List)result.get();
            if (resultRows.size() == 0) {
                return Optional.empty();
            }
            resultRow = (Row)resultRows.get(0);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MigrationException(String.format("Failed to query state for migration with version %s: %s", version, e.getMessage()));
        }
        return Optional.of(MigrationVersionInfo.fromResultRow(resultRow));
    }

    public static Map<Integer, Optional<MigrationVersionInfo>> getOptionalInfoForVersions(List<Integer> versions, MigrationConfig config, Client ksqlClient) {
        if (MetadataUtil.serverSupportsMultiKeyPullQuery(ksqlClient, config)) {
            Map<Integer, MigrationVersionInfo> resultSet;
            String migrationTableName = config.getString("ksql.migrations.table.name");
            BatchedQueryResult result = ksqlClient.executeQuery("SELECT version, checksum, previous, state, name, started_on, completed_on, error_reason FROM " + migrationTableName + " WHERE version_key IN ('" + versions.stream().map(String::valueOf).collect(Collectors.joining("', '")) + "');");
            try {
                resultSet = ((List)result.get()).stream().map(MigrationVersionInfo::fromResultRow).collect(Collectors.toMap(MigrationVersionInfo::getVersion, vInfo -> vInfo));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new MigrationException(String.format("Failed to query state for migration with versions %s: %s", versions, e.getMessage()));
            }
            return versions.stream().collect(Collectors.toMap(v -> v, v -> Optional.ofNullable((MigrationVersionInfo)resultSet.get(v))));
        }
        return versions.stream().collect(Collectors.toMap(v -> v, v -> MetadataUtil.getOptionalInfoForVersion(String.valueOf(v), config, ksqlClient)));
    }

    private static boolean serverSupportsMultiKeyPullQuery(Client ksqlClient, MigrationConfig config) {
        String ksqlServerUrl = config.getString("ksql.server.url");
        ServerInfo serverInfo = ServerVersionUtil.getServerInfo(ksqlClient, ksqlServerUrl);
        return ServerVersionUtil.versionSupportsMultiKeyPullQuery(serverInfo.getServerVersion());
    }

    public static enum MigrationState {
        PENDING,
        RUNNING,
        MIGRATED,
        ERROR;

    }
}

