/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.migrations.util;

import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.ServerInfo;
import io.confluent.ksql.tools.migrations.MigrationConfig;
import io.confluent.ksql.tools.migrations.MigrationException;
import io.confluent.ksql.util.KsqlVersion;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerVersionUtil {
    private static final Logger LOGGER = LogManager.getLogger(ServerVersionUtil.class);

    private ServerVersionUtil() {
    }

    public static ServerInfo getServerInfo(Client ksqlClient, String ksqlServerUrl) {
        CompletableFuture response;
        try {
            response = ksqlClient.serverInfo();
        }
        catch (IllegalArgumentException e) {
            throw new MigrationException(String.format("Could not connect to %s/info: %s", ksqlServerUrl, e.getMessage()));
        }
        try {
            return (ServerInfo)response.get();
        }
        catch (InterruptedException e) {
            throw new MigrationException("Interrupted while attempting to connect to " + ksqlServerUrl + "/info");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalStateException) {
                throw new MigrationException(e.getCause().getMessage() + "\nPlease ensure that " + ksqlServerUrl + " is an active ksqlDB server and that the version of the migration tool is compatible with the version of the ksqlDB server.");
            }
            throw new MigrationException("Failed to query " + ksqlServerUrl + "/info: " + e.getMessage());
        }
    }

    public static boolean isSupportedVersion(String ksqlServerVersion) {
        KsqlVersion version;
        try {
            version = new KsqlVersion(ksqlServerVersion);
        }
        catch (IllegalArgumentException e) {
            throw new MigrationException("Could not parse ksqlDB server version to verify compatibility. Version: " + ksqlServerVersion);
        }
        return version.isAtLeast(new KsqlVersion("6.0."));
    }

    public static boolean versionSupportsMultiKeyPullQuery(String ksqlServerVersion) {
        KsqlVersion version;
        try {
            version = new KsqlVersion(ksqlServerVersion);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Could not parse ksqlDB server version to verify whether multi-key pull queries are supported. Falling back to single-key pull queries only.");
            return false;
        }
        return version.isAtLeast(new KsqlVersion("6.1."));
    }

    public static boolean serverVersionCompatible(Client ksqlClient, MigrationConfig config) {
        ServerInfo serverInfo;
        String ksqlServerUrl = config.getString("ksql.server.url");
        try {
            serverInfo = ServerVersionUtil.getServerInfo(ksqlClient, ksqlServerUrl);
        }
        catch (MigrationException e) {
            LOGGER.error("Failed to get server info to verify version compatibility: {}", (Object)e.getMessage());
            return false;
        }
        String serverVersion = serverInfo.getServerVersion();
        try {
            return ServerVersionUtil.isSupportedVersion(serverVersion);
        }
        catch (MigrationException e) {
            LOGGER.warn(e.getMessage() + ". Proceeding anyway.");
            return true;
        }
    }
}

