/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.aws;

import com.google.common.base.Splitter;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.confluent.kafka.schemaregistry.encryption.aws.AwsKmsAead;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClientBuilder;

public final class AwsKmsClient
implements KmsClient {
    public static final String PREFIX = "aws-kms://";
    @Nullable
    private software.amazon.awssdk.services.kms.KmsClient awsKms;
    @Nullable
    private String keyUri;
    @Nullable
    private AwsCredentialsProvider provider;

    public AwsKmsClient() {
    }

    public AwsKmsClient(String uri) {
        if (!uri.toLowerCase(Locale.US).startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must starts with aws-kms://");
        }
        this.keyUri = uri;
    }

    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase(Locale.US).startsWith(PREFIX);
    }

    @CanIgnoreReturnValue
    public KmsClient withCredentials(String credentialPath) throws GeneralSecurityException {
        try {
            if (credentialPath == null) {
                return this.withDefaultCredentials();
            }
            return this.withCredentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.builder().profileFile(ProfileFile.builder().content(Paths.get(credentialPath, new String[0])).build()).build());
        }
        catch (AwsServiceException e) {
            throw new GeneralSecurityException("cannot load credentials", e);
        }
    }

    @CanIgnoreReturnValue
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        try {
            return this.withCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create());
        }
        catch (AwsServiceException e) {
            throw new GeneralSecurityException("cannot load default credentials", e);
        }
    }

    @CanIgnoreReturnValue
    public KmsClient withCredentialsProvider(AwsCredentialsProvider provider) throws GeneralSecurityException {
        this.provider = provider;
        return this;
    }

    @CanIgnoreReturnValue
    KmsClient withAwsKms(@Nullable software.amazon.awssdk.services.kms.KmsClient awsKms) {
        this.awsKms = awsKms;
        return this;
    }

    protected static String removePrefix(String expectedPrefix, String kmsKeyUri) {
        if (!kmsKeyUri.toLowerCase(Locale.US).startsWith(expectedPrefix)) {
            throw new IllegalArgumentException(String.format("key URI must start with %s", expectedPrefix));
        }
        return kmsKeyUri.substring(expectedPrefix.length());
    }

    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        try {
            String keyId = AwsKmsClient.removePrefix(PREFIX, uri);
            software.amazon.awssdk.services.kms.KmsClient client = this.awsKms;
            List tokens = Splitter.on((char)':').splitToList((CharSequence)keyId);
            if (tokens.size() < 4) {
                throw new IllegalArgumentException("invalid key URI");
            }
            String regionName = (String)tokens.get(3);
            if (client == null) {
                client = (software.amazon.awssdk.services.kms.KmsClient)((KmsClientBuilder)((KmsClientBuilder)software.amazon.awssdk.services.kms.KmsClient.builder().credentialsProvider(this.provider)).region(Region.of((String)regionName))).build();
            }
            return new AwsKmsAead(client, keyId);
        }
        catch (AwsServiceException e) {
            throw new GeneralSecurityException("cannot load credentials from provider", e);
        }
    }

    public static void register(Optional<String> keyUri, Optional<String> credentialPath) throws GeneralSecurityException {
        AwsKmsClient.registerWithAwsKms(keyUri, credentialPath, null);
    }

    static void registerWithAwsKms(Optional<String> keyUri, Optional<String> credentialPath, @Nullable software.amazon.awssdk.services.kms.KmsClient awsKms) throws GeneralSecurityException {
        AwsKmsClient client = keyUri.isPresent() ? new AwsKmsClient(keyUri.get()) : new AwsKmsClient();
        if (credentialPath.isPresent()) {
            client.withCredentials(credentialPath.get());
        } else {
            client.withDefaultCredentials();
        }
        client.withAwsKms(awsKms);
        KmsClients.add((KmsClient)client);
    }
}

