/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.Objects;

@Immutable
public final class SqlArray
extends SqlType {
    private final SqlType itemType;

    public static SqlArray of(SqlType itemType) {
        return new SqlArray(itemType);
    }

    private SqlArray(SqlType itemType) {
        super(SqlBaseType.ARRAY);
        this.itemType = Objects.requireNonNull(itemType, "itemType");
    }

    public SqlType getItemType() {
        return this.itemType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlArray array = (SqlArray)o;
        return Objects.equals(this.itemType, array.itemType);
    }

    public int hashCode() {
        return Objects.hash(this.itemType);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    @Override
    public String toString(FormatOptions formatOptions) {
        return "ARRAY<" + this.itemType.toString(formatOptions) + ">";
    }
}

