/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.Objects;

@Immutable
public final class SqlMap
extends SqlType {
    private final SqlType keyType;
    private final SqlType valueType;

    public static SqlMap of(SqlType keyType, SqlType valueType) {
        return new SqlMap(keyType, valueType);
    }

    private SqlMap(SqlType keyType, SqlType valueType) {
        super(SqlBaseType.MAP);
        this.keyType = Objects.requireNonNull(keyType, "keyType");
        this.valueType = Objects.requireNonNull(valueType, "valueType");
    }

    public SqlType getKeyType() {
        return this.keyType;
    }

    public SqlType getValueType() {
        return this.valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlMap map = (SqlMap)o;
        return Objects.equals(this.keyType, map.keyType) && Objects.equals(this.valueType, map.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    @Override
    public String toString(FormatOptions formatOptions) {
        return "MAP<" + this.keyType.toString(formatOptions) + ", " + this.valueType.toString(formatOptions) + ">";
    }
}

