/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.utils.DataException;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

@Immutable
public final class KsqlStruct {
    @EffectivelyImmutable
    private final ImmutableList<Optional<?>> values;

    public static Builder builder(SqlStruct schema) {
        return new Builder(schema);
    }

    private KsqlStruct(List<Optional<?>> values) {
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values"));
    }

    public Optional<?> get(int index) {
        KsqlStruct.validateIndex(index, this.values);
        return (Optional)this.values.get(index);
    }

    public Accessor accessor(SqlStruct schema) {
        return new Accessor(schema);
    }

    public Builder asBuilder(SqlStruct schema) {
        Builder builder = KsqlStruct.builder(schema);
        UnmodifiableListIterator it = this.values.listIterator();
        while (it.hasNext()) {
            int idx = it.nextIndex();
            builder.set(idx, (Optional)it.next());
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlStruct that = (KsqlStruct)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return "Struct(" + this.values.stream().map(v -> v.orElse(null)).map(Objects::toString).collect(Collectors.joining(",")) + ")";
    }

    private static int fieldIndex(String name, SqlStruct schema) {
        ListIterator<SqlStruct.Field> it = schema.fields().listIterator();
        while (it.hasNext()) {
            int idx = it.nextIndex();
            if (!it.next().name().equals(name)) continue;
            return idx;
        }
        throw new DataException("Unknown field: " + name);
    }

    private static void validateIndex(int index, List<?> values) {
        if (index < 0 || values.size() <= index) {
            throw new DataException("Invalid field index: " + index);
        }
    }

    public static final class Builder {
        private final SqlStruct schema;
        private final List<Optional<?>> values;

        private Builder(SqlStruct schema) {
            this.schema = Objects.requireNonNull(schema, "schema");
            this.values = new ArrayList(schema.fields().size());
            schema.fields().forEach(f -> this.values.add(Optional.empty()));
        }

        public Builder set(int fieldIndex, Object value) {
            return this.set(fieldIndex, Optional.ofNullable(value));
        }

        public Builder set(int fieldIndex, Optional<?> value) {
            KsqlStruct.validateIndex(fieldIndex, this.values);
            this.values.set(fieldIndex, value);
            return this;
        }

        public Builder set(String fieldName, Object value) {
            return this.set(fieldName, Optional.ofNullable(value));
        }

        public Builder set(String fieldName, Optional<?> value) {
            return this.set(KsqlStruct.fieldIndex(fieldName, this.schema), value);
        }

        public KsqlStruct build() {
            return new KsqlStruct(this.values);
        }
    }

    public final class Accessor {
        private final SqlStruct schema;

        private Accessor(SqlStruct schema) {
            this.schema = Objects.requireNonNull(schema, "schema");
            int schemaFields = schema.fields().size();
            int values = KsqlStruct.this.values.size();
            Preconditions.checkArgument((schemaFields == values ? 1 : 0) != 0, (Object)("schema/value size mismatch: schema:" + schemaFields + ", values:" + values));
        }

        public Optional<?> get(String fieldName) {
            int index = KsqlStruct.fieldIndex(fieldName, this.schema);
            return (Optional)KsqlStruct.this.values.get(index);
        }

        public void forEach(BiConsumer<? super SqlStruct.Field, ? super Optional<?>> consumer) {
            Iterator<SqlStruct.Field> fieldIt = this.schema.fields().iterator();
            UnmodifiableIterator valueIt = KsqlStruct.this.values.iterator();
            while (fieldIt.hasNext()) {
                SqlStruct.Field field = fieldIt.next();
                Optional value = (Optional)valueIt.next();
                consumer.accept(field, value);
            }
        }
    }
}

