/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.confluent.resourcemanager.api.client.Request;
import io.confluent.resourcemanager.api.client.Subresource;
import io.confluent.resourcemanager.api.model.GroupVersionResource;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.ObjectList;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ScopeAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;

public final class ListRequest<T extends HasMetadata>
extends Request<ObjectList<T>> {
    public ListRequest(String baseUrl, OkHttpClient httpClient, JavaType elementType, GroupVersionResource gvr, Scoping scoping, String kind, TypeFactory typeFactory) {
        this(baseUrl, httpClient, elementType, gvr, Location.Default(), scoping, typeFactory);
        this.kind = kind;
    }

    private ListRequest(String baseUrl, OkHttpClient httpClient, JavaType elementType, GroupVersionResource gvr, Location location, Scoping scoping, TypeFactory typeFactory) {
        super(baseUrl, httpClient, typeFactory.constructParametricType(ObjectList.class, new JavaType[]{elementType}), gvr, Objects.requireNonNull(location), scoping, new ArrayList<ScopeAttribute>());
    }

    public ListRequest<T> location(Location location) {
        this.location = Objects.requireNonNull(location);
        return this;
    }

    public ListRequest<T> allLocations(boolean allLocations) {
        if (allLocations) {
            this.urlBuilder.setQueryParameter("allLocations", String.valueOf(allLocations));
        }
        return this;
    }

    public ListRequest<T> scope(List<ScopeAttribute> scope) {
        this.scope = Objects.requireNonNull(scope);
        return this;
    }

    public ListRequest<T> labelSelector(String labelSelector) {
        this.urlBuilder.setQueryParameter("labelSelector", Objects.requireNonNull(labelSelector));
        return this;
    }

    public ListRequest<T> fieldSelector(String fieldSelector) {
        this.urlBuilder.setQueryParameter("fieldSelector", Objects.requireNonNull(fieldSelector));
        return this;
    }

    public ListRequest<T> limit(int limit) {
        this.urlBuilder.setQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public ListRequest<T> continueToken(String continueToken) {
        this.urlBuilder.setQueryParameter("continueToken", Objects.requireNonNull(continueToken));
        return this;
    }

    @Deprecated
    public ListRequest<T> eventuallyConsistent(boolean eventuallyConsistent) {
        this.urlBuilder.setQueryParameter("eventuallyConsistent", String.valueOf(eventuallyConsistent));
        return this;
    }

    public ListRequest<T> stronglyConsistent(Boolean stronglyConsistent) {
        if (stronglyConsistent == null) {
            this.urlBuilder.removeAllQueryParameters("stronglyConsistent");
        } else {
            this.urlBuilder.setQueryParameter("stronglyConsistent", String.valueOf(stronglyConsistent));
        }
        return this;
    }

    public ListRequest<T> reverseOrder(boolean reverseOrder) {
        this.urlBuilder.setQueryParameter("reverseOrder", String.valueOf(reverseOrder));
        return this;
    }

    @Override
    public CompletableFuture<ObjectList<T>> execute() {
        return this.exec(b -> b);
    }

    @Override
    public ListRequest<T> subresource(String subresource) {
        super.subresource(subresource);
        return this;
    }

    @Override
    public ListRequest<T> subresource(Subresource subresource) {
        super.subresource(subresource);
        return this;
    }
}

