/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Refill;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class RateLimit {
    private static final int TOKEN_EACH_TIME = 1;
    private static final int DEFAULT_TOKEN_REFILL_TIME = 1;
    public static final int DEFAULT_QPS = 5;
    public static final int DEFAULT_BURST = 10;
    private static final boolean DEFAULT_DISABLE_CLIENT_RATE_LIMITING = true;
    private boolean clientRateLimitingDisabled;
    protected final Bucket bucket;

    public RateLimit() {
        this(5, 10, true);
    }

    public RateLimit(boolean clientRateLimitingDisabled) {
        this(5, 10, clientRateLimitingDisabled);
    }

    public RateLimit(int qps, int burst, boolean clientRateLimitingDisabled) {
        if (qps <= 0) {
            throw new IllegalArgumentException("qps must be greater than 0");
        }
        if (burst <= 0) {
            throw new IllegalArgumentException("burst must be greater than 0");
        }
        this.bucket = this.initializeRateLimit(qps, burst);
        this.clientRateLimitingDisabled = clientRateLimitingDisabled;
    }

    public boolean getClientRateLimitingDisabled() {
        return this.clientRateLimitingDisabled;
    }

    private Bucket initializeRateLimit(int qps, int burst) {
        Bandwidth limit = Bandwidth.classic((long)burst, (Refill)Refill.intervally((long)qps, (Duration)Duration.ofSeconds(1L)));
        return Bucket.builder().addLimit(limit).build();
    }

    private RuntimeException createInterruptedException() {
        return new RuntimeException("Rate limiting was interrupted");
    }

    public <T> T executeWithRateLimit(Supplier<T> supplier) {
        if (Thread.interrupted()) {
            throw this.createInterruptedException();
        }
        try {
            this.bucket.asBlocking().consume(1L);
            return supplier.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.createInterruptedException();
        }
    }

    public static OkHttpClient.Builder updateRateLimitedHttpClientBuilder(OkHttpClient.Builder builder, RateLimit rateLimit) {
        return builder.addInterceptor((Interceptor)new HttpRateLimitInterceptor(rateLimit));
    }

    public static ManagedChannelBuilder<?> updateRateLimitedGrpcClient(ManagedChannelBuilder<?> builder, RateLimit rateLimit) {
        builder.intercept(new ClientInterceptor[]{new GrpcRateLimitInterceptor(rateLimit)});
        return builder;
    }

    public static NettyChannelBuilder updateRateLimitedSpireGrpcClient(NettyChannelBuilder builder, RateLimit rateLimit) {
        builder.intercept(new ClientInterceptor[]{new GrpcRateLimitInterceptor(rateLimit)});
        return builder;
    }

    static class HttpRateLimitInterceptor
    implements Interceptor {
        private final RateLimit rateLimit;

        HttpRateLimitInterceptor(RateLimit rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Nonnull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            try {
                return this.rateLimit.executeWithRateLimit(() -> {
                    try {
                        return chain.proceed(chain.request());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }
    }

    static class GrpcRateLimitInterceptor
    implements ClientInterceptor {
        private final RateLimit rateLimit;

        GrpcRateLimitInterceptor(RateLimit rateLimit) {
            this.rateLimit = rateLimit;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    rateLimit.executeWithRateLimit(() -> {
                        super.start(responseListener, headers);
                        return null;
                    });
                }
            };
        }
    }
}

