/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.client.MediaTypes;
import io.confluent.resourcemanager.api.client.Request;
import io.confluent.resourcemanager.api.client.Subresource;
import io.confluent.resourcemanager.api.model.GroupVersionResource;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.api.openapi.Adapter;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public final class UpdateRequest<T extends HasMetadata>
extends Request<Optional<T>> {
    private T object;

    UpdateRequest(String baseUrl, OkHttpClient httpClient, Adapter<?> object, GroupVersionResource gvr, Scoping scoping) {
        super(baseUrl, httpClient, ClientImpl.OBJECT_MAPPER.getTypeFactory().constructParametricType(Optional.class, new JavaType[]{Objects.requireNonNull(object).getJavaType()}), gvr, Location.from(object.getMetadata().getLocation()), scoping, object.getMetadata().getScopeList());
        this.setObject(object);
    }

    UpdateRequest(String baseUrl, OkHttpClient httpClient, T object, GroupVersionResource gvr, Scoping scoping) {
        super(baseUrl, httpClient, ClientImpl.OBJECT_MAPPER.getTypeFactory().constructParametricType(Optional.class, new Class[]{((HasMetadata)Objects.requireNonNull(object)).getClass()}), gvr, Location.from(object.getMetadata().getLocation()), scoping, Objects.requireNonNull(((HasMetadata)Objects.requireNonNull(object)).getMetadata()).getScopeList());
        this.setObject(object);
    }

    private void setObject(T object) {
        this.object = object;
        this.objectName = Objects.requireNonNull(object.getMetadata().getName());
        this.kind = object.getKind();
    }

    @Override
    public CompletableFuture<Optional<T>> execute() {
        return this.exec(b -> b.put(RequestBody.create((byte[])UpdateRequest.serializeObject(this.object), (MediaType)MediaTypes.MEDIA_TYPE_JSON)));
    }

    @Override
    public UpdateRequest<T> subresource(String subresource) {
        super.subresource(subresource);
        return this;
    }

    @Override
    public UpdateRequest<T> subresource(Subresource subresource) {
        super.subresource(subresource);
        return this;
    }
}

