/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.confluent.resourcemanager.api.model.GroupVersion;
import io.confluent.resourcemanager.api.model.GroupVersionKind;
import io.confluent.resourcemanager.api.model.identifier.ObjectIdentifier;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.openapi.Adapter;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ObjectMeta;
import java.util.HashMap;
import java.util.Map;

public class Unstructured
extends Adapter<Map<Object, Object>> {
    @JsonCreator
    public Unstructured(Map<Object, Object> unstructuredContent) {
        super(new HashMap<Object, Object>(unstructuredContent));
    }

    public Unstructured(GroupVersionKind gvk) {
        super(Map.of("apiVersion", gvk.group() + "/" + gvk.version(), "kind", gvk.kind()));
    }

    @Override
    public void setGroupVersionKind(GroupVersionKind gvk) {
        HashMap<Object, Object> unstructuredContent = new HashMap<Object, Object>(this.getUnstructuredContent());
        unstructuredContent.put("apiVersion", gvk.group() + "/" + gvk.version());
        unstructuredContent.put("kind", gvk.kind());
        this.setUnstructuredContent(unstructuredContent);
    }

    @Override
    public String getGroup() {
        return this.getGroupVersion().group();
    }

    @Override
    public String getVersion() {
        return this.getGroupVersion().version();
    }

    @Override
    public String getKind() {
        Object kind = this.getUnstructuredContent().get("kind");
        if (kind == null) {
            throw new IllegalArgumentException("kind is not set");
        }
        return kind.toString();
    }

    private GroupVersion getGroupVersion() {
        String apiVersion = this.getApiVersion();
        String[] parts = apiVersion.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid apiVersion: " + apiVersion);
        }
        return new GroupVersion(parts[0], parts[1]);
    }

    @Override
    public String getApiVersion() {
        Object apiVersion = this.getUnstructuredContent().get("apiVersion");
        if (apiVersion == null) {
            throw new IllegalArgumentException("apiVersion is not set");
        }
        return apiVersion.toString();
    }

    public Map<Object, Object> getUnstructuredContent() {
        return (Map)this.getOpenApiObject();
    }

    public void setUnstructuredContent(Map<Object, Object> unstructuredContent) {
        this.setOpenApiObject(unstructuredContent);
    }

    @Override
    public JavaType getJavaType() {
        return TypeFactory.defaultInstance().constructType(Unstructured.class);
    }

    @Override
    public ObjectIdentifier<Unstructured> identifier() {
        ObjectMeta metadata = this.getMetadata();
        return new ObjectIdentifier<Unstructured>(Location.from(metadata.getLocation()), metadata.getScopeList(), metadata.getName(), this.getJavaType(), this.getGroupVersionKind());
    }

    private GroupVersionKind getGroupVersionKind() {
        return new GroupVersionKind(this.getGroup(), this.getVersion(), this.getKind());
    }
}

