/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.model.location;

import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;
import lombok.Generated;

public class Location {
    private static final HashSet<String> cloudProviders = new HashSet<String>(Arrays.asList("aws", "azure", "gcp"));
    private static final Pattern regionRegex = Pattern.compile("^[a-z0-9][a-z0-9-]*[a-z0-9]$");
    private static final String regionalPrefix = "regional";
    private static final Location globalLocation = new Location("global");
    private static final Location defaultLocation = new Location("");
    protected String name;

    public String toString() {
        return this.name;
    }

    private Location() {
    }

    private Location(String name) {
        this.name = name;
    }

    public static Location Default() {
        return defaultLocation;
    }

    public static Location Global() {
        return globalLocation;
    }

    public static Location Regional(String cloud, String region) {
        if (!cloudProviders.contains(cloud)) {
            throw new IllegalArgumentException(String.format("expected regional location to contain one of %s, but got %s", cloudProviders, cloud));
        }
        if (!regionRegex.matcher(region).find()) {
            throw new IllegalArgumentException(String.format("expected regional location to contain a region that matches the format '%s'", regionRegex));
        }
        return new Location(String.format("%s.%s.%s", regionalPrefix, cloud, region));
    }

    private static Location Regional(String str) {
        if (str == null) {
            throw new IllegalArgumentException("provided regional location was null");
        }
        String[] parts = str.split(Pattern.quote("."));
        if (parts.length != 3) {
            throw new IllegalArgumentException("expected regional location to follow pattern 'regional.<cloud>.<region>'");
        }
        if (!parts[0].equals(regionalPrefix)) {
            throw new IllegalArgumentException("expected regional location to start with 'regional'");
        }
        return Location.Regional(parts[1], parts[2]);
    }

    public static Location from(String str) {
        if (str == null || str.isEmpty()) {
            return defaultLocation;
        }
        if (str.equals(Location.globalLocation.name)) {
            return globalLocation;
        }
        return Location.Regional(str);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

