/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.internal.restmapper;

import io.confluent.resourcemanager.api.model.GroupVersionKind;
import io.confluent.resourcemanager.api.model.GroupVersionResource;
import io.confluent.resourcemanager.internal.discovery.DiscoveryClient;
import io.confluent.resourcemanager.internal.discovery.model.APIGroupDiscovery;
import io.confluent.resourcemanager.internal.discovery.model.APIGroupDiscoveryList;
import io.confluent.resourcemanager.internal.discovery.model.APIResourceDiscovery;
import io.confluent.resourcemanager.internal.discovery.model.APIVersionDiscovery;
import io.confluent.resourcemanager.internal.restmapper.RESTMapping;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class RESTMapper {
    private DiscoveryClient discoveryClient;
    public APIGroupDiscoveryList apiGroupDiscoveryList;

    public RESTMapper(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    private APIGroupDiscoveryList getApiGroupDiscoveryList() {
        if (this.apiGroupDiscoveryList == null) {
            this.refresh();
        }
        return this.apiGroupDiscoveryList;
    }

    public void refresh() {
        this.apiGroupDiscoveryList = this.discoveryClient.listAPIGroups().join();
    }

    public Optional<RESTMapping> getMapping(GroupVersionKind gvk) {
        APIGroupDiscoveryList groups = this.getApiGroupDiscoveryList();
        if (groups == null || groups.items() == null || groups.items().isEmpty()) {
            return Optional.empty();
        }
        List matchingGroups = groups.items().stream().filter(group -> group.metadata().getName().equals(gvk.group())).collect(Collectors.toList());
        if (matchingGroups.size() != 1) {
            return Optional.empty();
        }
        APIGroupDiscovery group2 = (APIGroupDiscovery)matchingGroups.get(0);
        List versions = group2.versions().stream().filter(version -> version.version().equals(gvk.version())).collect(Collectors.toList());
        if (versions.size() != 1) {
            return Optional.empty();
        }
        APIVersionDiscovery version2 = (APIVersionDiscovery)versions.get(0);
        List resources = version2.resources().stream().filter(resource -> resource.kind().equals(gvk.kind())).collect(Collectors.toList());
        if (resources.size() != 1) {
            return Optional.empty();
        }
        APIResourceDiscovery resource2 = (APIResourceDiscovery)resources.get(0);
        return Optional.of(new RESTMapping(new GroupVersionResource(gvk.group(), gvk.version(), resource2.resource()), gvk, resource2.scope(), resource2.locality()));
    }
}

