/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DelegationTokenRecord
implements ApiMessage {
    String owner;
    String requester;
    List<String> renewers;
    long issueTimestamp;
    long maxTimestamp;
    long expirationTimestamp;
    String tokenId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("owner", (Type)Type.COMPACT_STRING, "The delegation token owner."), new Field("requester", (Type)Type.COMPACT_STRING, "The delegation token requester."), new Field("renewers", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "The principals which can renew this token."), new Field("issue_timestamp", (Type)Type.INT64, "The time at which this timestamp was issued."), new Field("max_timestamp", (Type)Type.INT64, "The time at which this token cannot be renewed any more."), new Field("expiration_timestamp", (Type)Type.INT64, "The next time at which this token must be renewed."), new Field("token_id", (Type)Type.COMPACT_STRING, "The token id."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DelegationTokenRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DelegationTokenRecord() {
        this.owner = "";
        this.requester = "";
        this.renewers = new ArrayList<String>(0);
        this.issueTimestamp = 0L;
        this.maxTimestamp = 0L;
        this.expirationTimestamp = 0L;
        this.tokenId = "";
    }

    public short apiKey() {
        return 10;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field owner was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field owner had invalid length " + length);
        }
        this.owner = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field requester was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field requester had invalid length " + length);
        }
        this.requester = _readable.readString(length);
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field renewers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            int length2 = _readable.readUnsignedVarint() - 1;
            if (length2 < 0) {
                throw new RuntimeException("non-nullable field renewers element was serialized as null");
            }
            if (length2 > Short.MAX_VALUE) {
                throw new RuntimeException("string field renewers element had invalid length " + length2);
            }
            newCollection.add(_readable.readString(length2));
        }
        this.renewers = newCollection;
        this.issueTimestamp = _readable.readLong();
        this.maxTimestamp = _readable.readLong();
        this.expirationTimestamp = _readable.readLong();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field tokenId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field tokenId had invalid length " + length);
        }
        this.tokenId = _readable.readString(length);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue((Object)this.owner);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray(_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.requester);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray(_stringBytes);
        _writable.writeUnsignedVarint(this.renewers.size() + 1);
        _stringBytes = this.renewers.iterator();
        while (_stringBytes.hasNext()) {
            String renewersElement = (String)_stringBytes.next();
            byte[] _stringBytes2 = _cache.getSerializedValue((Object)renewersElement);
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
        }
        _writable.writeLong(this.issueTimestamp);
        _writable.writeLong(this.maxTimestamp);
        _writable.writeLong(this.expirationTimestamp);
        _stringBytes = _cache.getSerializedValue((Object)this.tokenId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray(_stringBytes);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = this.owner.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'owner' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.owner, _stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        _stringBytes = this.requester.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'requester' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.requester, _stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.renewers.size() + 1)));
        _stringBytes = this.renewers.iterator();
        while (_stringBytes.hasNext()) {
            String renewersElement = (String)_stringBytes.next();
            byte[] _stringBytes2 = renewersElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes2.length > Short.MAX_VALUE) {
                throw new RuntimeException("'renewersElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)renewersElement, _stringBytes2);
            _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
        }
        _size.addBytes(8);
        _size.addBytes(8);
        _size.addBytes(8);
        _stringBytes = this.tokenId.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'tokenId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.tokenId, _stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DelegationTokenRecord)) {
            return false;
        }
        DelegationTokenRecord other = (DelegationTokenRecord)obj;
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.requester == null ? other.requester != null : !this.requester.equals(other.requester)) {
            return false;
        }
        if (this.renewers == null ? other.renewers != null : !this.renewers.equals(other.renewers)) {
            return false;
        }
        if (this.issueTimestamp != other.issueTimestamp) {
            return false;
        }
        if (this.maxTimestamp != other.maxTimestamp) {
            return false;
        }
        if (this.expirationTimestamp != other.expirationTimestamp) {
            return false;
        }
        if (this.tokenId == null ? other.tokenId != null : !this.tokenId.equals(other.tokenId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.owner == null ? 0 : this.owner.hashCode());
        hashCode = 31 * hashCode + (this.requester == null ? 0 : this.requester.hashCode());
        hashCode = 31 * hashCode + (this.renewers == null ? 0 : this.renewers.hashCode());
        hashCode = 31 * hashCode + ((int)(this.issueTimestamp >> 32) ^ (int)this.issueTimestamp);
        hashCode = 31 * hashCode + ((int)(this.maxTimestamp >> 32) ^ (int)this.maxTimestamp);
        hashCode = 31 * hashCode + ((int)(this.expirationTimestamp >> 32) ^ (int)this.expirationTimestamp);
        hashCode = 31 * hashCode + (this.tokenId == null ? 0 : this.tokenId.hashCode());
        return hashCode;
    }

    public DelegationTokenRecord duplicate() {
        DelegationTokenRecord _duplicate = new DelegationTokenRecord();
        _duplicate.owner = this.owner;
        _duplicate.requester = this.requester;
        ArrayList<String> newRenewers = new ArrayList<String>(this.renewers.size());
        for (String _element : this.renewers) {
            newRenewers.add(_element);
        }
        _duplicate.renewers = newRenewers;
        _duplicate.issueTimestamp = this.issueTimestamp;
        _duplicate.maxTimestamp = this.maxTimestamp;
        _duplicate.expirationTimestamp = this.expirationTimestamp;
        _duplicate.tokenId = this.tokenId;
        return _duplicate;
    }

    public String toString() {
        return "DelegationTokenRecord(owner=" + (String)(this.owner == null ? "null" : "'" + this.owner.toString() + "'") + ", requester=" + (String)(this.requester == null ? "null" : "'" + this.requester.toString() + "'") + ", renewers=" + MessageUtil.deepToString(this.renewers.iterator()) + ", issueTimestamp=" + this.issueTimestamp + ", maxTimestamp=" + this.maxTimestamp + ", expirationTimestamp=" + this.expirationTimestamp + ", tokenId=" + (String)(this.tokenId == null ? "null" : "'" + this.tokenId.toString() + "'") + ")";
    }

    public String owner() {
        return this.owner;
    }

    public String requester() {
        return this.requester;
    }

    public List<String> renewers() {
        return this.renewers;
    }

    public long issueTimestamp() {
        return this.issueTimestamp;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public long expirationTimestamp() {
        return this.expirationTimestamp;
    }

    public String tokenId() {
        return this.tokenId;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DelegationTokenRecord setOwner(String v) {
        this.owner = v;
        return this;
    }

    public DelegationTokenRecord setRequester(String v) {
        this.requester = v;
        return this;
    }

    public DelegationTokenRecord setRenewers(List<String> v) {
        this.renewers = v;
        return this;
    }

    public DelegationTokenRecord setIssueTimestamp(long v) {
        this.issueTimestamp = v;
        return this;
    }

    public DelegationTokenRecord setMaxTimestamp(long v) {
        this.maxTimestamp = v;
        return this;
    }

    public DelegationTokenRecord setExpirationTimestamp(long v) {
        this.expirationTimestamp = v;
        return this;
    }

    public DelegationTokenRecord setTokenId(String v) {
        this.tokenId = v;
        return this;
    }
}

