/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import io.confluent.metrics.record.ConfluentMetric;
import java.util.HashMap;
import java.util.Map;

public class YammerMetricsUtils {
    private static final String NAME = ",name=";
    private static final char COMMA = ',';
    private static final char EQUALS = '=';

    public static Map<String, String> extractTags(String metricName) {
        int pos = metricName.indexOf(NAME);
        Preconditions.checkArgument((pos >= 0 ? 1 : 0) != 0, (Object)("invalid metric, missing name: " + metricName));
        HashMap tags = Maps.newHashMap();
        int end = metricName.indexOf(44, pos += NAME.length());
        tags.put("name", metricName.substring(pos, end >= 0 ? end : metricName.length()));
        pos = end + 1;
        while (pos > 0) {
            int equals = metricName.indexOf(61, pos);
            end = metricName.indexOf(44, pos);
            if (equals != -1 && (equals < end || end == -1)) {
                String key = metricName.substring(pos, equals);
                String value = metricName.substring(equals + 1, end > 0 ? end : metricName.length());
                tags.put(key, value);
            }
            pos = end + 1;
        }
        return tags;
    }

    public static Iterable<YammerMetric> metricsIterable(Iterable<? extends Message> list) {
        return FluentIterable.from(list).transformAndConcat((Function)new Function<Message, Iterable<? extends YammerMetric>>(){

            public Iterable<? extends YammerMetric> apply(Message input) {
                if (input == null) {
                    throw new IllegalArgumentException("Invalid null input");
                }
                if (input instanceof ConfluentMetric.YammerGauge) {
                    return ImmutableList.of((Object)YammerMetricsUtils.forMessage((ConfluentMetric.YammerGauge)input));
                }
                if (input instanceof ConfluentMetric.YammerMeter) {
                    return ImmutableList.of((Object)YammerMetricsUtils.forMessage((ConfluentMetric.YammerMeter)input));
                }
                if (input instanceof ConfluentMetric.YammerHistogram) {
                    return YammerMetricsUtils.forMessage((ConfluentMetric.YammerHistogram)input);
                }
                if (input instanceof ConfluentMetric.YammerTimer) {
                    return ImmutableList.of((Object)YammerMetricsUtils.forMessage((ConfluentMetric.YammerTimer)input));
                }
                throw new IllegalArgumentException("Unknown message type " + String.valueOf(input.getClass()));
            }
        });
    }

    private static YammerMetric forMessage(final ConfluentMetric.YammerGauge metric) {
        return new AbstractYammerMetric(metric.getMetricName()){

            @Override
            public long longAggregate() {
                switch (metric.getNumericValueCase()) {
                    case LONGVALUE: {
                        return metric.getLongValue();
                    }
                    case DOUBLEVALUE: {
                        return (long)metric.getDoubleValue();
                    }
                }
                try {
                    return Long.parseLong(metric.getValue());
                }
                catch (NumberFormatException e) {
                    try {
                        return (long)Double.parseDouble(metric.getValue());
                    }
                    catch (NumberFormatException e1) {
                        return 0L;
                    }
                }
            }

            @Override
            public double doubleAggregate() {
                switch (metric.getNumericValueCase()) {
                    case LONGVALUE: {
                        return metric.getLongValue();
                    }
                    case DOUBLEVALUE: {
                        return metric.getDoubleValue();
                    }
                }
                try {
                    return Double.parseDouble(metric.getValue());
                }
                catch (NumberFormatException e) {
                    return 0.0;
                }
            }
        };
    }

    private static YammerMetric forMessage(final ConfluentMetric.YammerMeter metric) {
        return new AbstractYammerMetric(metric.getMetricName()){

            @Override
            public long longAggregate() {
                return metric.getDeltaCount();
            }
        };
    }

    private static YammerMetric forMessage(final ConfluentMetric.YammerTimer metric) {
        return new AbstractYammerMetric(metric.getMetricName()){

            @Override
            public long longAggregate() {
                return metric.getDeltaCount();
            }
        };
    }

    private static Iterable<YammerMetric> forMessage(final ConfluentMetric.YammerHistogram metric) {
        return ImmutableList.of((Object)new AbstractYammerMetric(metric.getMetricName()){

            @Override
            public long longAggregate() {
                return metric.getDeltaCount();
            }
        }, (Object)new SuffixedYammerMetric(metric.getMetricName(), "p95"){

            @Override
            public long longAggregate() {
                return (long)metric.getPercentile95Th();
            }
        }, (Object)new SuffixedYammerMetric(metric.getMetricName(), "p99"){

            @Override
            public long longAggregate() {
                return (long)metric.getPercentile99Th();
            }
        }, (Object)new SuffixedYammerMetric(metric.getMetricName(), "p999"){

            @Override
            public long longAggregate() {
                return (long)metric.getPercentile999Th();
            }
        }, (Object)new SuffixedYammerMetric(metric.getMetricName(), "p50"){

            @Override
            public long longAggregate() {
                return (long)metric.getMedian();
            }
        });
    }

    private static abstract class SuffixedYammerMetric
    extends AbstractYammerMetric {
        private final String suffix;

        public SuffixedYammerMetric(ConfluentMetric.YammerMetricName metricName, String suffix) {
            super(metricName);
            Preconditions.checkNotNull((Object)suffix, (Object)"metric suffix cannot be null");
            this.suffix = suffix;
        }

        @Override
        public String getName() {
            return super.getName() + "-" + this.suffix;
        }
    }

    private static abstract class AbstractYammerMetric
    implements YammerMetric {
        protected final ConfluentMetric.YammerMetricName metricName;

        public AbstractYammerMetric(ConfluentMetric.YammerMetricName metricName) {
            this.metricName = metricName;
        }

        @Override
        public String getGroup() {
            return this.metricName.getGroup();
        }

        @Override
        public String getType() {
            return this.metricName.getType();
        }

        @Override
        public String getName() {
            return this.metricName.getName();
        }

        @Override
        public Map<String, String> getTags() {
            return YammerMetricsUtils.extractTags(this.metricName.getMBeanName());
        }

        @Override
        public abstract long longAggregate();

        @Override
        public double doubleAggregate() {
            return 0.0;
        }
    }

    public static interface YammerMetric {
        public String getGroup();

        public String getType();

        public String getName();

        public Map<String, String> getTags();

        public long longAggregate();

        public double doubleAggregate();
    }
}

