/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.path;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.path.generated.PathExpressionParser;
import com.api.jsonata4java.expressions.path.generated.PathExpressionParserBaseVisitor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.ListIterator;
import org.antlr.v4.runtime.tree.ParseTree;

public abstract class PathExpressionVisitor
extends PathExpressionParserBaseVisitor<JsonNode> {
    public static final String ERR_INDEX_VAR_UNSET = "Reference made to unset variable $index";
    private final Integer indexVarValue;
    private JsonNode json;
    private JsonNode currentNode;

    public static final String ERR_FIELD_ON_NON_OBJECT(String fieldName) {
        return "Attempt to reference field " + fieldName + " of a non-object";
    }

    public static final String ERR_INDEX_ON_NON_ARRAY(String fieldName, int index) {
        return "Cannot reference index " + index + " on non-array field " + fieldName;
    }

    public static final String ERR_ARR_INDEX_OUT_OF_BOUNDS(String fieldName, int index) {
        return "Index " + index + " is out of bounds for the array " + fieldName;
    }

    public PathExpressionVisitor(JsonNode json, Integer indexVarValue) {
        this.json = json;
        this.indexVarValue = indexVarValue;
        this.currentNode = json;
    }

    private void updateCurrentNodePointer(JsonNode n) {
        this.currentNode = n;
    }

    private JsonNode getCurrentNodePointer() {
        return this.currentNode;
    }

    @Override
    public JsonNode visitPath(PathExpressionParser.PathContext ctx) {
        String fieldName = ctx.id().txt.getText();
        if (this.getCurrentNodePointer() == null) {
            throw new EvaluateRuntimeException("Unexpected null pointer");
        }
        if (!this.getCurrentNodePointer().isObject()) {
            throw new EvaluateRuntimeException(PathExpressionVisitor.ERR_FIELD_ON_NON_OBJECT(fieldName));
        }
        ObjectNode currentObject = (ObjectNode)this.getCurrentNodePointer();
        List<PathExpressionParser.Array_indexContext> ctx_indexes = ctx.array_index();
        if (ctx_indexes == null || ctx_indexes.isEmpty()) {
            if (ctx.rhs == null) {
                return this.reachedObjectField(currentObject, fieldName);
            }
            JsonNode nextNode = currentObject.get(fieldName);
            if (nextNode == null) {
                nextNode = new ObjectNode(JsonNodeFactory.instance);
                currentObject.put(fieldName, nextNode);
            }
            this.updateCurrentNodePointer(nextNode);
            return (JsonNode)this.visit((ParseTree)ctx.rhs);
        }
        JsonNode nextNode = currentObject.get(fieldName);
        if (nextNode == null) {
            nextNode = new ArrayNode(JsonNodeFactory.instance);
            currentObject.put(fieldName, nextNode);
        }
        Object fieldNamePlusLeadingIndexes = fieldName;
        ListIterator<PathExpressionParser.Array_indexContext> it = ctx_indexes.listIterator();
        while (it.hasNext()) {
            PathExpressionParser.Array_indexContext ctx_index = it.next();
            Integer index = null;
            if (ctx_index.NUMBER() == null) {
                throw new RuntimeException();
            }
            index = Integer.valueOf(ctx_index.NUMBER().getText());
            if (!nextNode.isArray()) {
                throw new EvaluateRuntimeException(PathExpressionVisitor.ERR_INDEX_ON_NON_ARRAY((String)fieldNamePlusLeadingIndexes, index));
            }
            ArrayNode currentArray = (ArrayNode)nextNode;
            if (index >= currentArray.size()) {
                throw new EvaluateRuntimeException(PathExpressionVisitor.ERR_ARR_INDEX_OUT_OF_BOUNDS((String)fieldNamePlusLeadingIndexes, index));
            }
            if (it.hasNext()) {
                fieldNamePlusLeadingIndexes = (String)fieldNamePlusLeadingIndexes + "[" + index + "]";
                nextNode = currentArray.get(index.intValue());
                continue;
            }
            if (ctx.rhs == null) {
                return this.reachedArrayIndex(currentArray, index);
            }
            this.updateCurrentNodePointer(currentArray.get(index.intValue()));
            return (JsonNode)this.visit((ParseTree)ctx.rhs);
        }
        throw new RuntimeException("This can never happen at runtime, this is just to keep the compiler happy");
    }

    protected abstract JsonNode reachedObjectField(ObjectNode var1, String var2);

    protected abstract JsonNode reachedArrayIndex(ArrayNode var1, int var2);

    public static void main(String[] args) {
    }

    public static class Getter
    extends PathExpressionVisitor {
        public Getter(JsonNode json, Integer indexVarValue) {
            super(json, indexVarValue);
        }

        @Override
        protected JsonNode reachedObjectField(ObjectNode object, String fieldName) {
            return object.get(fieldName);
        }

        @Override
        protected JsonNode reachedArrayIndex(ArrayNode array, int index) {
            return array.get(index);
        }
    }

    public static class Setter
    extends PathExpressionVisitor {
        private final JsonNode valueToAssign;

        public Setter(JsonNode json, Integer indexVarValue, JsonNode valueToAssign) {
            super(json, indexVarValue);
            this.valueToAssign = valueToAssign;
        }

        @Override
        protected JsonNode reachedObjectField(ObjectNode object, String fieldName) {
            object.set(fieldName, this.valueToAssign);
            return this.valueToAssign;
        }

        @Override
        protected JsonNode reachedArrayIndex(ArrayNode array, int index) {
            array.set(index, this.valueToAssign);
            return this.valueToAssign;
        }
    }
}

