/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.logevents.connect;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.remote.config.poller.ConnectLogEventsConfig;
import io.confluent.remote.config.poller.Region;
import java.util.Map;
import java.util.Objects;

public class RemoteConnectLogsConfiguration {
    private static final String SCHEMA_VERSION = "1.0";
    private final String activeRegion;
    private final Map<Region, ConnectLogEventsConfig> connectLogEventsProducerConfig;

    @JsonCreator
    public RemoteConnectLogsConfiguration(@JsonProperty(value="activeRegion") String activeRegion, @JsonProperty(value="regionProducerConfig") Map<Region, ConnectLogEventsConfig> connectLogEventsProducerConfig) {
        this.activeRegion = Objects.requireNonNull(activeRegion, "activeRegion can't be null");
        this.connectLogEventsProducerConfig = connectLogEventsProducerConfig;
    }

    @JsonIgnore
    public static String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getActiveRegion() {
        return this.activeRegion;
    }

    public ConnectLogEventsConfig getConnectLogEventsProducerConfig(Region region) {
        return this.connectLogEventsProducerConfig.get(region);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteConnectLogsConfiguration)) {
            return false;
        }
        RemoteConnectLogsConfiguration that = (RemoteConnectLogsConfiguration)o;
        return Objects.equals(this.activeRegion, that.activeRegion) && Objects.equals(this.connectLogEventsProducerConfig, that.connectLogEventsProducerConfig);
    }

    public int hashCode() {
        return Objects.hash(this.activeRegion, this.connectLogEventsProducerConfig);
    }
}

