/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.annotations.restrictions.PathKind;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import java.io.File;

public class PathRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private final boolean mustExist;
    private final boolean readable;
    private final boolean writable;
    private final boolean executable;
    private final PathKind kind;

    public PathRestriction(boolean mustExist, boolean readable, boolean writable, boolean executable, PathKind kind) {
        this.mustExist = mustExist;
        this.readable = readable;
        this.writable = writable;
        this.executable = executable;
        this.kind = kind;
    }

    protected void validate(String title, String path) {
        block15: {
            File f;
            block16: {
                block14: {
                    if (path == null) {
                        throw new ParseRestrictionViolatedException("%s must be given a non-null path", title, path);
                    }
                    f = new File(path);
                    if (this.mustExist && !f.exists()) {
                        throw new ParseRestrictionViolatedException("%s was given value '%s' which is not a path to an existing file/directory", title, path);
                    }
                    if (!this.mustExist || !f.exists()) break block14;
                    switch (this.kind) {
                        case FILE: {
                            if (f.isFile()) break;
                            throw new ParseRestrictionViolatedException("%s was given value '%s' which is not a path to a file", title, path);
                        }
                        case DIRECTORY: {
                            if (f.isDirectory()) break;
                            throw new ParseRestrictionViolatedException("%s was given value '%s' which is not a path to a directory", title, path);
                        }
                        default: {
                            if (f.isFile() || f.isDirectory()) break;
                            throw new ParseRestrictionViolatedException("%s was given value '%s' which is not a path to a file/directory", title, path);
                        }
                    }
                    if (this.readable && !f.canRead()) {
                        this.notReadable(title, path);
                    }
                    if (this.writable && !f.canWrite()) {
                        this.notWritable(title, path);
                    }
                    if (!this.executable || f.canExecute()) break block15;
                    this.notExecutable(title, path);
                    break block15;
                }
                if (!this.readable && !this.writable && !this.executable) break block15;
                if (!f.isAbsolute()) {
                    f = f.getAbsoluteFile();
                }
                if (!f.exists()) break block16;
                if (this.readable && !f.canRead()) {
                    this.notReadable(title, path);
                }
                if (this.writable && !f.canWrite()) {
                    this.notWritable(title, path);
                }
                if (!this.executable || f.canExecute()) break block15;
                this.notExecutable(title, path);
                break block15;
            }
            while (f.getParentFile() != null) {
                if (!(f = f.getParentFile()).exists()) continue;
                if (this.readable && !f.canRead()) {
                    this.notReadable(title, path);
                }
                if (this.writable && !f.canWrite()) {
                    this.notWritable(title, path);
                }
                if (!this.executable || f.canExecute()) break;
                this.notExecutable(title, path);
                break;
            }
        }
    }

    private void notExecutable(String title, String path) {
        throw new ParseRestrictionViolatedException("%s was given value '%s' which is not a executable path", title, path);
    }

    private void notWritable(String title, String path) {
        throw new ParseRestrictionViolatedException("%s was given value '%s' which is not a writeable path", title, path);
    }

    private void notReadable(String title, String path) {
        throw new ParseRestrictionViolatedException("%s was given value '%s' which it not a readable path", title, path);
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
        this.validate(String.format("Option '%s'", option.getTitle()), value);
    }

    @Override
    public <T> void preValidate(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        this.validate(String.format("Argument '%s'", AbstractCommonRestriction.getArgumentTitle(state, arguments)), value);
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        StringBuilder builder = new StringBuilder();
        switch (this.kind) {
            case FILE: {
                builder.append("This options value must be a path to a file.");
                break;
            }
            case DIRECTORY: {
                builder.append("This options value must be a path to a directory.");
            }
        }
        if (this.mustExist) {
            if (builder.length() == 0) {
                builder.append("This options value must be a path that must exist on the file system.");
            } else {
                builder.append(" The provided path must exist on the file system.");
            }
        }
        if (this.readable) {
            if (builder.length() == 0) {
                builder.append("This options value must be a path on the file system that must be readable");
            } else {
                builder.append(" The provided path must be readable");
            }
        }
        if (this.writable) {
            if (builder.length() == 0) {
                builder.append("This options value must be a path on the file system that must be writable");
            } else if (this.readable) {
                if (this.executable) {
                    builder.append(", writable");
                } else {
                    builder.append(" and writable");
                }
            } else {
                builder.append(" The provided path must be writable");
            }
        }
        if (this.executable) {
            if (builder.length() == 0) {
                builder.append("This options value must be a path on the file system that must be executable");
            } else if (this.readable || this.writable) {
                builder.append(" and executable");
            } else {
                builder.append(" The provided path must be executable");
            }
        }
        if (this.readable || this.writable || this.executable) {
            builder.append('.');
        }
        if (builder.length() == 0) {
            builder.append("This options value must be a path.");
        }
        return new String[]{builder.toString()};
    }
}

