/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.utils.predicates;

import com.github.rvesse.airline.utils.predicates.AbstractLocaleSensitiveStringFinder;
import java.util.Locale;

public class SuffixMatcher
extends AbstractLocaleSensitiveStringFinder {
    private final String[] suffixes;
    private final boolean ignoreCase;

    public SuffixMatcher(boolean ignoreCase, Locale locale, String ... suffixes) {
        super(locale);
        this.ignoreCase = ignoreCase;
        this.suffixes = suffixes;
        if (ignoreCase) {
            int i = 0;
            while (i < this.suffixes.length) {
                this.suffixes[i] = this.suffixes[i].toLowerCase(locale);
                ++i;
            }
        }
    }

    public boolean evaluate(String str) {
        String[] stringArray = this.suffixes;
        int n = this.suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (str.length() < suffix.length()) {
                return false;
            }
            String strSuffix = str.substring(str.length() - suffix.length());
            if (this.ignoreCase) {
                strSuffix = strSuffix.toLowerCase(this.locale);
            }
            if (this.collator.compare(strSuffix, suffix) == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

