/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.tink;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriverManager;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeadWrapper
implements Aead {
    private static final Logger log = LoggerFactory.getLogger(AeadWrapper.class);
    public static final String ENCRYPT_ALTERNATE_KMS_KEY_IDS = "encrypt.alternate.kms.key.ids";
    private final Map<String, ?> configs;
    private final String kmsType;
    private final String kmsKeyId;
    private final List<String> kmsKeyIds;

    public AeadWrapper(Map<String, ?> configs, String kmsType, String kmsKeyId) {
        this.configs = configs;
        this.kmsType = kmsType;
        this.kmsKeyId = kmsKeyId;
        this.kmsKeyIds = this.getKmsKeyIds();
    }

    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        for (int i = 0; i < this.kmsKeyIds.size(); ++i) {
            try {
                Aead aead = AeadWrapper.getAead(this.configs, this.kmsType, this.kmsKeyIds.get(i));
                return aead.encrypt(plaintext, associatedData);
            }
            catch (Exception e) {
                log.warn("Failed to encrypt with kms key id {}: {}", (Object)this.kmsKeyIds.get(i), (Object)e.getMessage());
                if (i != this.kmsKeyIds.size() - 1) continue;
                throw e instanceof GeneralSecurityException ? (GeneralSecurityException)e : new GeneralSecurityException("Failed to encrypt with all KEKs", e);
            }
        }
        throw new GeneralSecurityException("No KMS key IDs available for encryption");
    }

    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        for (int i = 0; i < this.kmsKeyIds.size(); ++i) {
            try {
                Aead aead = AeadWrapper.getAead(this.configs, this.kmsType, this.kmsKeyIds.get(i));
                return aead.decrypt(ciphertext, associatedData);
            }
            catch (Exception e) {
                log.warn("Failed to decrypt with kms key id {}: {}", (Object)this.kmsKeyIds.get(i), (Object)e.getMessage());
                if (i != this.kmsKeyIds.size() - 1) continue;
                throw e instanceof GeneralSecurityException ? (GeneralSecurityException)e : new GeneralSecurityException("Failed to decrypt with all KEKs", e);
            }
        }
        throw new GeneralSecurityException("No KMS key IDs available for decryption");
    }

    private List<String> getKmsKeyIds() {
        ArrayList<String> kmsKeyIds = new ArrayList<String>();
        kmsKeyIds.add(this.kmsKeyId);
        String alternateKmsKeyIds = (String)this.configs.get(ENCRYPT_ALTERNATE_KMS_KEY_IDS);
        if (alternateKmsKeyIds != null && !alternateKmsKeyIds.isEmpty()) {
            String[] ids;
            for (String id : ids = alternateKmsKeyIds.split("\\s*,\\s*")) {
                if (id.isEmpty()) continue;
                kmsKeyIds.add(id);
            }
        }
        return kmsKeyIds;
    }

    private static Aead getAead(Map<String, ?> configs, String kmsType, String kmsKeyId) throws GeneralSecurityException {
        String kekUrl = kmsType + "://" + kmsKeyId;
        KmsClient kmsClient = AeadWrapper.getKmsClient(configs, kekUrl);
        if (kmsClient == null) {
            throw new GeneralSecurityException("No kms client found for " + kekUrl);
        }
        return kmsClient.getAead(kekUrl);
    }

    private static KmsClient getKmsClient(Map<String, ?> configs, String kekUrl) throws GeneralSecurityException {
        try {
            return KmsDriverManager.getDriver(kekUrl).getKmsClient(kekUrl);
        }
        catch (GeneralSecurityException e) {
            return KmsDriverManager.getDriver(kekUrl).registerKmsClient(configs, Optional.of(kekUrl));
        }
    }
}

