/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaProvider.class);
    public static final String AVRO_VALIDATE_DEFAULTS = "avro.validate.defaults";
    private boolean validateDefaults = false;

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        String validate = (String)configs.get(AVRO_VALIDATE_DEFAULTS);
        this.validateDefaults = Boolean.parseBoolean(validate);
    }

    @Override
    public String schemaType() {
        return "AVRO";
    }

    @Override
    public ParsedSchema parseSchemaOrElseThrow(Schema schema, boolean isNew, boolean normalize) {
        try {
            return new AvroSchema(schema.getSchema(), schema.getReferences(), this.resolveReferences(schema, isNew), schema.getMetadata(), schema.getRuleSet(), null, (this.validateDefaults || normalize) && isNew);
        }
        catch (Exception e) {
            log.error("Could not parse Avro schema", (Throwable)e);
            throw e;
        }
    }
}

