/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteShareGroupStateRequest;
import org.apache.kafka.common.requests.DeleteShareGroupStateResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.InitializeShareGroupStateRequest;
import org.apache.kafka.common.requests.InitializeShareGroupStateResponse;
import org.apache.kafka.common.requests.ReadShareGroupStateRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateResponse;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryRequest;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryResponse;
import org.apache.kafka.common.requests.WriteShareGroupStateRequest;
import org.apache.kafka.common.requests.WriteShareGroupStateResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.persister.PersisterStateBatch;
import org.apache.kafka.server.share.persister.ShareCoordinatorMetadataCacheHelper;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.server.util.timer.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersisterStateManager {
    private SendThread sender;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    public static final long REQUEST_BACKOFF_MS = 1000L;
    public static final long REQUEST_BACKOFF_MAX_MS = 30000L;
    private static final int MAX_FIND_COORD_ATTEMPTS = 5;
    private final Time time;
    private final Timer timer;
    private final ShareCoordinatorMetadataCacheHelper cacheHelper;
    private final Map<RPCType, Set<Node>> inFlight = new HashMap<RPCType, Set<Node>>();
    private final Map<Node, Map<RPCType, Map<String, List<PersisterStateManagerHandler>>>> nodeRPCMap = new HashMap<Node, Map<RPCType, Map<String, List<PersisterStateManagerHandler>>>>();
    private final Object nodeMapLock = new Object();
    private Runnable generateCallback;

    public PersisterStateManager(KafkaClient client, ShareCoordinatorMetadataCacheHelper cacheHelper, Time time, Timer timer) {
        if (client == null) {
            throw new IllegalArgumentException("Kafkaclient must not be null.");
        }
        if (time == null) {
            throw new IllegalArgumentException("Time must not be null.");
        }
        if (timer == null) {
            throw new IllegalArgumentException("Timer must not be null.");
        }
        if (cacheHelper == null) {
            throw new IllegalArgumentException("CacheHelper must not be null.");
        }
        this.time = time;
        this.timer = timer;
        this.cacheHelper = cacheHelper;
        this.sender = new SendThread("PersisterStateManager", client, Math.toIntExact(CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS), this.time, true, new Random(this.time.milliseconds()));
    }

    public void enqueue(PersisterStateManagerHandler handler) {
        this.sender.enqueue(handler);
    }

    public void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            this.sender.start();
            this.isStarted.set(true);
        }
    }

    public void stop() throws Exception {
        if (this.isStarted.compareAndSet(true, false)) {
            this.sender.shutdown();
            Utils.closeQuietly((AutoCloseable)this.timer, (String)"PersisterStateManager timer");
        }
    }

    Map<Node, Map<RPCType, Map<String, List<PersisterStateManagerHandler>>>> nodeRPCMap() {
        return this.nodeRPCMap;
    }

    public void setGenerateCallback(Runnable generateCallback) {
        this.generateCallback = generateCallback;
    }

    private class SendThread
    extends InterBrokerSendThread {
        private final ConcurrentLinkedQueue<PersisterStateManagerHandler> queue;
        private final Random random;

        public SendThread(String name, KafkaClient networkClient, int requestTimeoutMs, Time time, boolean isInterruptible, Random random) {
            super(name, networkClient, requestTimeoutMs, time, isInterruptible);
            this.queue = new ConcurrentLinkedQueue();
            this.random = random;
        }

        private Node randomNode() {
            List<Node> nodes = PersisterStateManager.this.cacheHelper.getClusterNodes();
            if (nodes == null || nodes.isEmpty()) {
                return Node.noNode();
            }
            return nodes.get(this.random.nextInt(nodes.size()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<RequestAndCompletionHandler> generateRequests() {
            if (PersisterStateManager.this.generateCallback != null) {
                PersisterStateManager.this.generateCallback.run();
            }
            ArrayList<RequestAndCompletionHandler> requests = new ArrayList<RequestAndCompletionHandler>();
            if (!this.queue.isEmpty()) {
                PersisterStateManagerHandler handler = this.queue.peek();
                this.queue.poll();
                if (handler.lookupNeeded()) {
                    Node randomNode = this.randomNode();
                    if (randomNode == Node.noNode()) {
                        this.log.error("Unable to find node to use for coordinator lookup.");
                        handler.findCoordinatorErrorResponse(Errors.COORDINATOR_NOT_AVAILABLE, (Exception)Errors.COORDINATOR_NOT_AVAILABLE.exception());
                        return List.of();
                    }
                    this.log.debug("Sending find coordinator RPC");
                    return List.of(new RequestAndCompletionHandler(PersisterStateManager.this.time.milliseconds(), randomNode, handler.findShareCoordinatorBuilder(), handler));
                }
                if (!handler.isBatchable()) {
                    requests.add(new RequestAndCompletionHandler(PersisterStateManager.this.time.milliseconds(), handler.coordinatorNode, handler.requestBuilder(), handler));
                }
            }
            HashMap<RPCType, Set> sending = new HashMap<RPCType, Set>();
            Object object = PersisterStateManager.this.nodeMapLock;
            synchronized (object) {
                PersisterStateManager.this.nodeRPCMap.forEach((coordNode, rpcTypesPerNode) -> rpcTypesPerNode.forEach((rpcType, groupsPerRpcType) -> groupsPerRpcType.forEach((groupId, handlersPerGroup) -> {
                    if (!PersisterStateManager.this.inFlight.containsKey(rpcType) || !PersisterStateManager.this.inFlight.get(rpcType).contains(coordNode)) {
                        AbstractRequest.Builder<? extends AbstractRequest> combinedRequestPerTypePerGroup = RequestCoalescerHelper.coalesceRequests(groupId, rpcType, handlersPerGroup);
                        requests.add(new RequestAndCompletionHandler(PersisterStateManager.this.time.milliseconds(), (Node)coordNode, combinedRequestPerTypePerGroup, response -> {
                            PersisterStateManager.this.inFlight.computeIfPresent((RPCType)((Object)((Object)rpcType)), (key, oldVal) -> {
                                oldVal.remove(coordNode);
                                return oldVal;
                            });
                            handlersPerGroup.forEach(handler1 -> handler1.onComplete(response));
                            this.wakeup();
                        }));
                        sending.computeIfAbsent((RPCType)((Object)rpcType), key -> new HashSet()).add(coordNode);
                    }
                })));
                sending.forEach((rpcType, nodeSet) -> {
                    PersisterStateManager.this.inFlight.computeIfAbsent((RPCType)((Object)rpcType), key -> new HashSet()).addAll(nodeSet);
                    nodeSet.forEach(node -> PersisterStateManager.this.nodeRPCMap.computeIfPresent((Node)node, (nodeKey, oldRPCTypeSet) -> {
                        oldRPCTypeSet.remove(rpcType);
                        return oldRPCTypeSet;
                    }));
                });
            }
            return requests;
        }

        public void enqueue(PersisterStateManagerHandler handler) {
            this.queue.add(handler);
            this.wakeup();
        }
    }

    public abstract class PersisterStateManagerHandler
    implements RequestCompletionHandler {
        protected Node coordinatorNode;
        private final BackoffManager findCoordBackoff;
        protected final Logger log = LoggerFactory.getLogger(this.getClass());
        private Consumer<ClientResponse> onCompleteCallback;
        protected final SharePartitionKey partitionKey;

        public PersisterStateManagerHandler(String groupId, Uuid topicId, int partition, long backoffMs, long backoffMaxMs, int maxRPCRetryAttempts) {
            this.findCoordBackoff = new BackoffManager(maxRPCRetryAttempts, backoffMs, backoffMaxMs);
            this.onCompleteCallback = response -> {};
            this.partitionKey = SharePartitionKey.getInstance(groupId, topicId, partition);
        }

        protected abstract AbstractRequest.Builder<? extends AbstractRequest> requestBuilder();

        protected abstract void handleRequestResponse(ClientResponse var1);

        protected abstract boolean isResponseForRequest(ClientResponse var1);

        protected abstract void findCoordinatorErrorResponse(Errors var1, Exception var2);

        protected abstract void requestErrorResponse(Errors var1, Exception var2);

        protected abstract String name();

        protected abstract RPCType rpcType();

        protected abstract CompletableFuture<? extends AbstractResponse> result();

        protected AbstractRequest.Builder<FindCoordinatorRequest> findShareCoordinatorBuilder() {
            return new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.SHARE.id()).setKey(this.partitionKey().asCoordinatorKey()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequestToNodeMap(Node node, PersisterStateManagerHandler handler) {
            if (!handler.isBatchable()) {
                return;
            }
            Object object = PersisterStateManager.this.nodeMapLock;
            synchronized (object) {
                PersisterStateManager.this.nodeRPCMap.computeIfAbsent(node, k -> new HashMap()).computeIfAbsent(handler.rpcType(), k -> new HashMap()).computeIfAbsent(this.partitionKey().groupId(), k -> new LinkedList()).add(handler);
            }
            PersisterStateManager.this.sender.wakeup();
        }

        protected boolean lookupNeeded() {
            if (this.coordinatorNode != null) {
                return false;
            }
            if (PersisterStateManager.this.cacheHelper.containsTopic("__share_group_state")) {
                this.log.debug("{} internal topic already exists.", (Object)"__share_group_state");
                Node node = PersisterStateManager.this.cacheHelper.getShareCoordinator(this.partitionKey(), "__share_group_state");
                if (node != Node.noNode()) {
                    this.log.debug("Found coordinator node in cache: {}", (Object)node);
                    this.coordinatorNode = node;
                    this.addRequestToNodeMap(node, this);
                    return false;
                }
            }
            return true;
        }

        protected SharePartitionKey partitionKey() {
            return this.partitionKey;
        }

        protected boolean isFindCoordinatorResponse(ClientResponse response) {
            return response != null && response.requestHeader().apiKey() == ApiKeys.FIND_COORDINATOR;
        }

        public void onComplete(ClientResponse response) {
            Optional<Errors> err;
            if (this.onCompleteCallback != null) {
                this.onCompleteCallback.accept(response);
            }
            if (response == null) {
                this.requestErrorResponse(Errors.UNKNOWN_SERVER_ERROR, (Exception)new NetworkException("Did not receive any response"));
                PersisterStateManager.this.sender.wakeup();
                return;
            }
            if (this.isFindCoordinatorResponse(response)) {
                Optional<Errors> err2 = this.checkNetworkError(response, this::findCoordinatorErrorResponse);
                if (err2.isEmpty()) {
                    this.handleFindCoordinatorResponse(response);
                }
            } else if (this.isResponseForRequest(response) && (err = this.checkNetworkError(response, this::requestErrorResponse)).isEmpty()) {
                this.handleRequestResponse(response);
            }
            PersisterStateManager.this.sender.wakeup();
        }

        Optional<Errors> checkNetworkError(ClientResponse response, BiConsumer<Errors, Exception> errorConsumer) {
            if (response.hasResponse()) {
                return Optional.empty();
            }
            this.log.error("Response for RPC {} with key {} is invalid - {}.", new Object[]{this.name(), this.partitionKey, response});
            if (response.wasDisconnected()) {
                errorConsumer.accept(Errors.NETWORK_EXCEPTION, null);
                return Optional.of(Errors.NETWORK_EXCEPTION);
            }
            if (response.wasTimedOut()) {
                errorConsumer.accept(Errors.REQUEST_TIMED_OUT, null);
                return Optional.of(Errors.REQUEST_TIMED_OUT);
            }
            errorConsumer.accept(Errors.UNKNOWN_SERVER_ERROR, (Exception)new NetworkException("Did not receive any response"));
            return Optional.of(Errors.UNKNOWN_SERVER_ERROR);
        }

        protected void resetCoordinatorNode() {
            this.coordinatorNode = null;
        }

        protected void handleFindCoordinatorResponse(ClientResponse response) {
            this.log.debug("Find coordinator response received - {}", (Object)response);
            this.findCoordBackoff.incrementAttempt();
            List coordinators = ((FindCoordinatorResponse)response.responseBody()).coordinators();
            if (coordinators.size() != 1) {
                this.log.error("Find coordinator response for {} is invalid", (Object)this.partitionKey());
                this.findCoordinatorErrorResponse(Errors.UNKNOWN_SERVER_ERROR, new IllegalStateException("Invalid response with multiple coordinators."));
                return;
            }
            FindCoordinatorResponseData.Coordinator coordinatorData = (FindCoordinatorResponseData.Coordinator)coordinators.get(0);
            Errors error = Errors.forCode((short)coordinatorData.errorCode());
            switch (error) {
                case NONE: {
                    this.log.debug("Find coordinator response valid. Enqueuing actual request.");
                    this.findCoordBackoff.resetAttempts();
                    this.coordinatorNode = new Node(coordinatorData.nodeId(), coordinatorData.host(), coordinatorData.port());
                    if (this.isBatchable()) {
                        this.addRequestToNodeMap(this.coordinatorNode, this);
                        break;
                    }
                    PersisterStateManager.this.enqueue(this);
                    break;
                }
                case COORDINATOR_NOT_AVAILABLE: 
                case COORDINATOR_LOAD_IN_PROGRESS: 
                case NOT_COORDINATOR: {
                    this.log.warn("Received retriable error in find coordinator for {} using key {}: {}", new Object[]{this.name(), this.partitionKey(), error.message()});
                    if (!this.findCoordBackoff.canAttempt()) {
                        this.log.error("Exhausted max retries to find coordinator for {} using key {} without success.", (Object)this.name(), (Object)this.partitionKey());
                        this.findCoordinatorErrorResponse(error, new Exception("Exhausted max retries to find coordinator without success."));
                        break;
                    }
                    this.resetCoordinatorNode();
                    PersisterStateManager.this.timer.add(new PersisterTimerTask(this.findCoordBackoff.backOff(), this));
                    break;
                }
                default: {
                    this.log.error("Unable to find coordinator for {} using key {}.", (Object)this.name(), (Object)this.partitionKey());
                    this.findCoordinatorErrorResponse(error, null);
                }
            }
        }

        public Node getCoordinatorNode() {
            return this.coordinatorNode;
        }

        protected abstract boolean isBatchable();

        protected void setOnCompleteCallback(Consumer<ClientResponse> callback) {
            this.onCompleteCallback = callback;
        }
    }

    private static class RequestCoalescerHelper {
        private RequestCoalescerHelper() {
        }

        public static AbstractRequest.Builder<? extends AbstractRequest> coalesceRequests(String groupId, RPCType rpcType, List<? extends PersisterStateManagerHandler> handlers) {
            return switch (rpcType) {
                case RPCType.WRITE -> RequestCoalescerHelper.coalesceWrites(groupId, handlers);
                case RPCType.READ -> RequestCoalescerHelper.coalesceReads(groupId, handlers);
                case RPCType.SUMMARY -> RequestCoalescerHelper.coalesceReadSummaries(groupId, handlers);
                case RPCType.DELETE -> RequestCoalescerHelper.coalesceDeletes(groupId, handlers);
                case RPCType.INITIALIZE -> RequestCoalescerHelper.coalesceInitializations(groupId, handlers);
                default -> throw new RuntimeException("Unknown rpc type: " + String.valueOf((Object)rpcType));
            };
        }

        private static AbstractRequest.Builder<? extends AbstractRequest> coalesceWrites(String groupId, List<? extends PersisterStateManagerHandler> handlers) {
            HashMap partitionData = new HashMap();
            handlers.forEach(persHandler -> {
                assert (persHandler instanceof WriteStateHandler);
                WriteStateHandler handler = (WriteStateHandler)persHandler;
                partitionData.computeIfAbsent(handler.partitionKey().topicId(), topicId -> new LinkedList()).add(new WriteShareGroupStateRequestData.PartitionData().setPartition(handler.partitionKey().partition()).setStateEpoch(handler.stateEpoch).setLeaderEpoch(handler.leaderEpoch).setStartOffset(handler.startOffset).setStateBatches(handler.batches.stream().map(batch -> new WriteShareGroupStateRequestData.StateBatch().setFirstOffset(batch.firstOffset()).setLastOffset(batch.lastOffset()).setDeliveryState(batch.deliveryState()).setDeliveryCount(batch.deliveryCount())).collect(Collectors.toList())));
            });
            return new WriteShareGroupStateRequest.Builder(new WriteShareGroupStateRequestData().setGroupId(groupId).setTopics(partitionData.entrySet().stream().map(entry -> new WriteShareGroupStateRequestData.WriteStateData().setTopicId((Uuid)entry.getKey()).setPartitions((List)entry.getValue())).collect(Collectors.toList())));
        }

        private static AbstractRequest.Builder<? extends AbstractRequest> coalesceReads(String groupId, List<? extends PersisterStateManagerHandler> handlers) {
            HashMap partitionData = new HashMap();
            handlers.forEach(persHandler -> {
                assert (persHandler instanceof ReadStateHandler);
                ReadStateHandler handler = (ReadStateHandler)persHandler;
                partitionData.computeIfAbsent(handler.partitionKey().topicId(), topicId -> new LinkedList()).add(new ReadShareGroupStateRequestData.PartitionData().setPartition(handler.partitionKey().partition()).setLeaderEpoch(handler.leaderEpoch));
            });
            return new ReadShareGroupStateRequest.Builder(new ReadShareGroupStateRequestData().setGroupId(groupId).setTopics(partitionData.entrySet().stream().map(entry -> new ReadShareGroupStateRequestData.ReadStateData().setTopicId((Uuid)entry.getKey()).setPartitions((List)entry.getValue())).collect(Collectors.toList())));
        }

        private static AbstractRequest.Builder<? extends AbstractRequest> coalesceReadSummaries(String groupId, List<? extends PersisterStateManagerHandler> handlers) {
            HashMap partitionData = new HashMap();
            handlers.forEach(persisterStateManagerHandler -> {
                assert (persisterStateManagerHandler instanceof ReadStateSummaryHandler);
                ReadStateSummaryHandler handler = (ReadStateSummaryHandler)persisterStateManagerHandler;
                partitionData.computeIfAbsent(handler.partitionKey().topicId(), topicId -> new LinkedList()).add(new ReadShareGroupStateSummaryRequestData.PartitionData().setPartition(handler.partitionKey().partition()).setLeaderEpoch(handler.leaderEpoch));
            });
            return new ReadShareGroupStateSummaryRequest.Builder(new ReadShareGroupStateSummaryRequestData().setGroupId(groupId).setTopics(partitionData.entrySet().stream().map(entry -> new ReadShareGroupStateSummaryRequestData.ReadStateSummaryData().setTopicId((Uuid)entry.getKey()).setPartitions((List)entry.getValue())).collect(Collectors.toList())));
        }

        private static AbstractRequest.Builder<? extends AbstractRequest> coalesceDeletes(String groupId, List<? extends PersisterStateManagerHandler> handlers) {
            HashMap partitionData = new HashMap();
            handlers.forEach(persHandler -> {
                assert (persHandler instanceof DeleteStateHandler);
                DeleteStateHandler handler = (DeleteStateHandler)persHandler;
                partitionData.computeIfAbsent(handler.partitionKey().topicId(), topicId -> new LinkedList()).add(new DeleteShareGroupStateRequestData.PartitionData().setPartition(handler.partitionKey().partition()));
            });
            return new DeleteShareGroupStateRequest.Builder(new DeleteShareGroupStateRequestData().setGroupId(groupId).setTopics(partitionData.entrySet().stream().map(entry -> new DeleteShareGroupStateRequestData.DeleteStateData().setTopicId((Uuid)entry.getKey()).setPartitions((List)entry.getValue())).toList()));
        }

        private static AbstractRequest.Builder<? extends AbstractRequest> coalesceInitializations(String groupId, List<? extends PersisterStateManagerHandler> handlers) {
            HashMap partitionData = new HashMap();
            handlers.forEach(persHandler -> {
                assert (persHandler instanceof InitializeStateHandler);
                InitializeStateHandler handler = (InitializeStateHandler)persHandler;
                partitionData.computeIfAbsent(handler.partitionKey().topicId(), topicId -> new LinkedList()).add(new InitializeShareGroupStateRequestData.PartitionData().setPartition(handler.partitionKey().partition()).setStateEpoch(handler.stateEpoch).setStartOffset(handler.startOffset));
            });
            return new InitializeShareGroupStateRequest.Builder(new InitializeShareGroupStateRequestData().setGroupId(groupId).setTopics(partitionData.entrySet().stream().map(entry -> new InitializeShareGroupStateRequestData.InitializeStateData().setTopicId((Uuid)entry.getKey()).setPartitions((List)entry.getValue())).toList()));
        }
    }

    private final class PersisterTimerTask
    extends TimerTask {
        private final PersisterStateManagerHandler handler;

        PersisterTimerTask(long delayMs, PersisterStateManagerHandler handler) {
            super(delayMs);
            this.handler = handler;
        }

        @Override
        public void run() {
            PersisterStateManager.this.enqueue(this.handler);
            PersisterStateManager.this.sender.wakeup();
        }
    }

    public class DeleteStateHandler
    extends PersisterStateManagerHandler {
        private final CompletableFuture<DeleteShareGroupStateResponse> result;
        private final BackoffManager deleteStateBackoff;

        public DeleteStateHandler(String groupId, Uuid topicId, int partition, CompletableFuture<DeleteShareGroupStateResponse> result, long backoffMs, long backoffMaxMs, int maxRPCRetryAttempts) {
            super(groupId, topicId, partition, backoffMs, backoffMaxMs, maxRPCRetryAttempts);
            this.result = result;
            this.deleteStateBackoff = new BackoffManager(maxRPCRetryAttempts, backoffMs, backoffMaxMs);
        }

        public DeleteStateHandler(String groupId, Uuid topicId, int partition, CompletableFuture<DeleteShareGroupStateResponse> result, Consumer<ClientResponse> onCompleteCallback) {
            this(groupId, topicId, partition, result, 1000L, 30000L, 5);
        }

        @Override
        protected String name() {
            return "DeleteStateHandler";
        }

        @Override
        protected AbstractRequest.Builder<? extends AbstractRequest> requestBuilder() {
            throw new RuntimeException("Delete requests are batchable, hence individual requests not needed.");
        }

        @Override
        protected boolean isResponseForRequest(ClientResponse response) {
            return response.requestHeader().apiKey() == ApiKeys.DELETE_SHARE_GROUP_STATE;
        }

        @Override
        protected void handleRequestResponse(ClientResponse response) {
            this.log.debug("Delete state response received - {}", (Object)response);
            this.deleteStateBackoff.incrementAttempt();
            DeleteShareGroupStateResponse combinedResponse = (DeleteShareGroupStateResponse)response.responseBody();
            for (DeleteShareGroupStateResponseData.DeleteStateResult deleteStateResult : combinedResponse.data().results()) {
                Optional<DeleteShareGroupStateResponseData.PartitionResult> partitionStateData;
                if (!deleteStateResult.topicId().equals((Object)this.partitionKey().topicId()) || !(partitionStateData = deleteStateResult.partitions().stream().filter(partitionResult -> partitionResult.partition() == this.partitionKey().partition()).findFirst()).isPresent()) continue;
                Errors error = Errors.forCode((short)partitionStateData.get().errorCode());
                switch (error) {
                    case NONE: {
                        this.deleteStateBackoff.resetAttempts();
                        DeleteShareGroupStateResponseData.DeleteStateResult result = DeleteShareGroupStateResponse.toResponseDeleteStateResult((Uuid)this.partitionKey().topicId(), List.of(partitionStateData.get()));
                        this.result.complete(new DeleteShareGroupStateResponse(new DeleteShareGroupStateResponseData().setResults(List.of(result))));
                        return;
                    }
                    case COORDINATOR_NOT_AVAILABLE: 
                    case COORDINATOR_LOAD_IN_PROGRESS: 
                    case NOT_COORDINATOR: {
                        this.log.warn("Received retriable error in delete state RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                        if (!this.deleteStateBackoff.canAttempt()) {
                            this.log.error("Exhausted max retries for delete state RPC for key {} without success.", (Object)this.partitionKey());
                            this.requestErrorResponse(error, new Exception("Exhausted max retries to complete delete state RPC without success."));
                            return;
                        }
                        super.resetCoordinatorNode();
                        PersisterStateManager.this.timer.add(new PersisterTimerTask(this.deleteStateBackoff.backOff(), this));
                        return;
                    }
                }
                this.log.error("Unable to perform delete state RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                this.requestErrorResponse(error, null);
                return;
            }
            IllegalStateException exception = new IllegalStateException("Failed to delete state for share partition: " + String.valueOf(this.partitionKey()));
            this.requestErrorResponse(Errors.forException((Throwable)exception), exception);
        }

        @Override
        protected void requestErrorResponse(Errors error, Exception exception) {
            this.result.complete(new DeleteShareGroupStateResponse(DeleteShareGroupStateResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in delete state RPC. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        @Override
        protected void findCoordinatorErrorResponse(Errors error, Exception exception) {
            this.result.complete(new DeleteShareGroupStateResponse(DeleteShareGroupStateResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in find coordinator. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        protected CompletableFuture<DeleteShareGroupStateResponse> result() {
            return this.result;
        }

        @Override
        protected boolean isBatchable() {
            return true;
        }

        @Override
        protected RPCType rpcType() {
            return RPCType.DELETE;
        }
    }

    public class ReadStateSummaryHandler
    extends PersisterStateManagerHandler {
        private final int leaderEpoch;
        private final CompletableFuture<ReadShareGroupStateSummaryResponse> result;
        private final BackoffManager readStateSummaryBackoff;

        public ReadStateSummaryHandler(String groupId, Uuid topicId, int partition, int leaderEpoch, CompletableFuture<ReadShareGroupStateSummaryResponse> result, long backoffMs, long backoffMaxMs, int maxRPCRetryAttempts, Consumer<ClientResponse> onCompleteCallback) {
            super(groupId, topicId, partition, backoffMs, backoffMaxMs, maxRPCRetryAttempts);
            this.leaderEpoch = leaderEpoch;
            this.result = result;
            this.readStateSummaryBackoff = new BackoffManager(maxRPCRetryAttempts, backoffMs, backoffMaxMs);
        }

        public ReadStateSummaryHandler(String groupId, Uuid topicId, int partition, int leaderEpoch, CompletableFuture<ReadShareGroupStateSummaryResponse> result, Consumer<ClientResponse> onCompleteCallback) {
            this(groupId, topicId, partition, leaderEpoch, result, 1000L, 30000L, 5, onCompleteCallback);
        }

        @Override
        protected String name() {
            return "ReadStateSummaryHandler";
        }

        protected AbstractRequest.Builder<ReadShareGroupStateSummaryRequest> requestBuilder() {
            throw new RuntimeException("Read Summary requests are batchable, hence individual requests not needed.");
        }

        @Override
        protected boolean isResponseForRequest(ClientResponse response) {
            return response.requestHeader().apiKey() == ApiKeys.READ_SHARE_GROUP_STATE_SUMMARY;
        }

        @Override
        protected void handleRequestResponse(ClientResponse response) {
            this.log.debug("Read state summary response received - {}", (Object)response);
            this.readStateSummaryBackoff.incrementAttempt();
            ReadShareGroupStateSummaryResponse combinedResponse = (ReadShareGroupStateSummaryResponse)response.responseBody();
            for (ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult readStateSummaryResult : combinedResponse.data().results()) {
                Optional<ReadShareGroupStateSummaryResponseData.PartitionResult> partitionStateData;
                if (!readStateSummaryResult.topicId().equals((Object)this.partitionKey().topicId()) || !(partitionStateData = readStateSummaryResult.partitions().stream().filter(partitionResult -> partitionResult.partition() == this.partitionKey().partition()).findFirst()).isPresent()) continue;
                Errors error = Errors.forCode((short)partitionStateData.get().errorCode());
                switch (error) {
                    case NONE: {
                        this.readStateSummaryBackoff.resetAttempts();
                        ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult result = ReadShareGroupStateSummaryResponse.toResponseReadStateSummaryResult((Uuid)this.partitionKey().topicId(), List.of(partitionStateData.get()));
                        this.result.complete(new ReadShareGroupStateSummaryResponse(new ReadShareGroupStateSummaryResponseData().setResults(List.of(result))));
                        return;
                    }
                    case COORDINATOR_NOT_AVAILABLE: 
                    case COORDINATOR_LOAD_IN_PROGRESS: 
                    case NOT_COORDINATOR: {
                        this.log.warn("Received retriable error in read state summary RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                        if (!this.readStateSummaryBackoff.canAttempt()) {
                            this.log.error("Exhausted max retries for read state summary RPC for key {} without success.", (Object)this.partitionKey());
                            this.requestErrorResponse(error, new Exception("Exhausted max retries to complete read state summary RPC without success."));
                            return;
                        }
                        super.resetCoordinatorNode();
                        PersisterStateManager.this.timer.add(new PersisterTimerTask(this.readStateSummaryBackoff.backOff(), this));
                        return;
                    }
                }
                this.log.error("Unable to perform read state summary RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                this.requestErrorResponse(error, null);
                return;
            }
            IllegalStateException exception = new IllegalStateException("Failed to read state summary for share partition " + String.valueOf(this.partitionKey()));
            this.requestErrorResponse(Errors.forException((Throwable)exception), exception);
        }

        @Override
        protected void requestErrorResponse(Errors error, Exception exception) {
            this.result.complete(new ReadShareGroupStateSummaryResponse(ReadShareGroupStateSummaryResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in read state summary RPC. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        @Override
        protected void findCoordinatorErrorResponse(Errors error, Exception exception) {
            this.result.complete(new ReadShareGroupStateSummaryResponse(ReadShareGroupStateSummaryResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in find coordinator. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        protected CompletableFuture<ReadShareGroupStateSummaryResponse> result() {
            return this.result;
        }

        @Override
        protected boolean isBatchable() {
            return true;
        }

        @Override
        protected RPCType rpcType() {
            return RPCType.SUMMARY;
        }
    }

    public class ReadStateHandler
    extends PersisterStateManagerHandler {
        private final int leaderEpoch;
        private final CompletableFuture<ReadShareGroupStateResponse> result;
        private final BackoffManager readStateBackoff;

        public ReadStateHandler(String groupId, Uuid topicId, int partition, int leaderEpoch, CompletableFuture<ReadShareGroupStateResponse> result, long backoffMs, long backoffMaxMs, int maxRPCRetryAttempts, Consumer<ClientResponse> onCompleteCallback) {
            super(groupId, topicId, partition, backoffMs, backoffMaxMs, maxRPCRetryAttempts);
            this.leaderEpoch = leaderEpoch;
            this.result = result;
            this.readStateBackoff = new BackoffManager(maxRPCRetryAttempts, backoffMs, backoffMaxMs);
        }

        public ReadStateHandler(String groupId, Uuid topicId, int partition, int leaderEpoch, CompletableFuture<ReadShareGroupStateResponse> result, Consumer<ClientResponse> onCompleteCallback) {
            this(groupId, topicId, partition, leaderEpoch, result, 1000L, 30000L, 5, onCompleteCallback);
        }

        @Override
        protected String name() {
            return "ReadStateHandler";
        }

        protected AbstractRequest.Builder<ReadShareGroupStateRequest> requestBuilder() {
            throw new RuntimeException("Read requests are batchable, hence individual requests not needed.");
        }

        @Override
        protected boolean isResponseForRequest(ClientResponse response) {
            return response.requestHeader().apiKey() == ApiKeys.READ_SHARE_GROUP_STATE;
        }

        @Override
        protected void handleRequestResponse(ClientResponse response) {
            this.log.debug("Read state response received - {}", (Object)response);
            this.readStateBackoff.incrementAttempt();
            ReadShareGroupStateResponse combinedResponse = (ReadShareGroupStateResponse)response.responseBody();
            for (ReadShareGroupStateResponseData.ReadStateResult readStateResult : combinedResponse.data().results()) {
                Optional<ReadShareGroupStateResponseData.PartitionResult> partitionStateData;
                if (!readStateResult.topicId().equals((Object)this.partitionKey().topicId()) || !(partitionStateData = readStateResult.partitions().stream().filter(partitionResult -> partitionResult.partition() == this.partitionKey().partition()).findFirst()).isPresent()) continue;
                Errors error = Errors.forCode((short)partitionStateData.get().errorCode());
                switch (error) {
                    case NONE: {
                        this.readStateBackoff.resetAttempts();
                        ReadShareGroupStateResponseData.ReadStateResult result = ReadShareGroupStateResponse.toResponseReadStateResult((Uuid)this.partitionKey().topicId(), List.of(partitionStateData.get()));
                        this.result.complete(new ReadShareGroupStateResponse(new ReadShareGroupStateResponseData().setResults(List.of(result))));
                        return;
                    }
                    case COORDINATOR_NOT_AVAILABLE: 
                    case COORDINATOR_LOAD_IN_PROGRESS: 
                    case NOT_COORDINATOR: {
                        this.log.warn("Received retriable error in read state RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                        if (!this.readStateBackoff.canAttempt()) {
                            this.log.error("Exhausted max retries for read state RPC for key {} without success.", (Object)this.partitionKey());
                            this.requestErrorResponse(error, new Exception("Exhausted max retries to complete read state RPC without success."));
                            return;
                        }
                        super.resetCoordinatorNode();
                        PersisterStateManager.this.timer.add(new PersisterTimerTask(this.readStateBackoff.backOff(), this));
                        return;
                    }
                }
                this.log.error("Unable to perform read state RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                this.requestErrorResponse(error, null);
                return;
            }
            IllegalStateException exception = new IllegalStateException("Failed to read state for share partition " + String.valueOf(this.partitionKey()));
            this.requestErrorResponse(Errors.forException((Throwable)exception), exception);
        }

        @Override
        protected void requestErrorResponse(Errors error, Exception exception) {
            this.result.complete(new ReadShareGroupStateResponse(ReadShareGroupStateResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in read state RPC. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        @Override
        protected void findCoordinatorErrorResponse(Errors error, Exception exception) {
            this.result.complete(new ReadShareGroupStateResponse(ReadShareGroupStateResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in find coordinator. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        protected CompletableFuture<ReadShareGroupStateResponse> result() {
            return this.result;
        }

        @Override
        protected boolean isBatchable() {
            return true;
        }

        @Override
        protected RPCType rpcType() {
            return RPCType.READ;
        }
    }

    public class WriteStateHandler
    extends PersisterStateManagerHandler {
        private final int stateEpoch;
        private final int leaderEpoch;
        private final long startOffset;
        private final List<PersisterStateBatch> batches;
        private final CompletableFuture<WriteShareGroupStateResponse> result;
        private final BackoffManager writeStateBackoff;

        public WriteStateHandler(String groupId, Uuid topicId, int partition, int stateEpoch, int leaderEpoch, long startOffset, List<PersisterStateBatch> batches, CompletableFuture<WriteShareGroupStateResponse> result, long backoffMs, long backoffMaxMs, int maxRPCRetryAttempts) {
            super(groupId, topicId, partition, backoffMs, backoffMaxMs, maxRPCRetryAttempts);
            this.stateEpoch = stateEpoch;
            this.leaderEpoch = leaderEpoch;
            this.startOffset = startOffset;
            this.batches = batches;
            this.result = result;
            this.writeStateBackoff = new BackoffManager(maxRPCRetryAttempts, backoffMs, backoffMaxMs);
        }

        public WriteStateHandler(String groupId, Uuid topicId, int partition, int stateEpoch, int leaderEpoch, long startOffset, List<PersisterStateBatch> batches, CompletableFuture<WriteShareGroupStateResponse> result, Consumer<ClientResponse> onCompleteCallback) {
            this(groupId, topicId, partition, stateEpoch, leaderEpoch, startOffset, batches, result, 1000L, 30000L, 5);
        }

        @Override
        protected String name() {
            return "WriteStateHandler";
        }

        @Override
        protected AbstractRequest.Builder<? extends AbstractRequest> requestBuilder() {
            throw new RuntimeException("Write requests are batchable, hence individual requests not needed.");
        }

        @Override
        protected boolean isResponseForRequest(ClientResponse response) {
            return response.requestHeader().apiKey() == ApiKeys.WRITE_SHARE_GROUP_STATE;
        }

        @Override
        protected void handleRequestResponse(ClientResponse response) {
            this.log.debug("Write state response received - {}", (Object)response);
            this.writeStateBackoff.incrementAttempt();
            WriteShareGroupStateResponse combinedResponse = (WriteShareGroupStateResponse)response.responseBody();
            for (WriteShareGroupStateResponseData.WriteStateResult writeStateResult : combinedResponse.data().results()) {
                Optional<WriteShareGroupStateResponseData.PartitionResult> partitionStateData;
                if (!writeStateResult.topicId().equals((Object)this.partitionKey().topicId()) || !(partitionStateData = writeStateResult.partitions().stream().filter(partitionResult -> partitionResult.partition() == this.partitionKey().partition()).findFirst()).isPresent()) continue;
                Errors error = Errors.forCode((short)partitionStateData.get().errorCode());
                switch (error) {
                    case NONE: {
                        this.writeStateBackoff.resetAttempts();
                        WriteShareGroupStateResponseData.WriteStateResult result = WriteShareGroupStateResponse.toResponseWriteStateResult((Uuid)this.partitionKey().topicId(), List.of(partitionStateData.get()));
                        this.result.complete(new WriteShareGroupStateResponse(new WriteShareGroupStateResponseData().setResults(List.of(result))));
                        return;
                    }
                    case COORDINATOR_NOT_AVAILABLE: 
                    case COORDINATOR_LOAD_IN_PROGRESS: 
                    case NOT_COORDINATOR: {
                        this.log.warn("Received retriable error in write state RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                        if (!this.writeStateBackoff.canAttempt()) {
                            this.log.error("Exhausted max retries for write state RPC for key {} without success.", (Object)this.partitionKey());
                            this.requestErrorResponse(error, new Exception("Exhausted max retries to complete write state RPC without success."));
                            return;
                        }
                        super.resetCoordinatorNode();
                        PersisterStateManager.this.timer.add(new PersisterTimerTask(this.writeStateBackoff.backOff(), this));
                        return;
                    }
                }
                this.log.error("Unable to perform write state RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                this.requestErrorResponse(error, null);
                return;
            }
            IllegalStateException exception = new IllegalStateException("Failed to write state for share partition: " + String.valueOf(this.partitionKey()));
            this.requestErrorResponse(Errors.forException((Throwable)exception), exception);
        }

        @Override
        public void requestErrorResponse(Errors error, Exception exception) {
            this.result.complete(new WriteShareGroupStateResponse(WriteShareGroupStateResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in write state RPC. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        @Override
        protected void findCoordinatorErrorResponse(Errors error, Exception exception) {
            this.result.complete(new WriteShareGroupStateResponse(WriteShareGroupStateResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in find coordinator. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        protected CompletableFuture<WriteShareGroupStateResponse> result() {
            return this.result;
        }

        @Override
        protected boolean isBatchable() {
            return true;
        }

        @Override
        protected RPCType rpcType() {
            return RPCType.WRITE;
        }
    }

    public class InitializeStateHandler
    extends PersisterStateManagerHandler {
        private final int stateEpoch;
        private final long startOffset;
        private final CompletableFuture<InitializeShareGroupStateResponse> result;
        private final BackoffManager initializeStateBackoff;

        public InitializeStateHandler(String groupId, Uuid topicId, int partition, int stateEpoch, long startOffset, CompletableFuture<InitializeShareGroupStateResponse> result, long backoffMs, long backoffMaxMs, int maxRPCRetryAttempts) {
            super(groupId, topicId, partition, backoffMs, backoffMaxMs, maxRPCRetryAttempts);
            this.stateEpoch = stateEpoch;
            this.startOffset = startOffset;
            this.result = result;
            this.initializeStateBackoff = new BackoffManager(maxRPCRetryAttempts, backoffMs, backoffMaxMs);
        }

        public InitializeStateHandler(String groupId, Uuid topicId, int partition, int stateEpoch, long startOffset, CompletableFuture<InitializeShareGroupStateResponse> result, Consumer<ClientResponse> onCompleteCallback) {
            this(groupId, topicId, partition, stateEpoch, startOffset, result, 1000L, 30000L, 5);
        }

        @Override
        protected String name() {
            return "InitializeStateHandler";
        }

        @Override
        protected AbstractRequest.Builder<? extends AbstractRequest> requestBuilder() {
            throw new RuntimeException("Initialize requests are batchable, hence individual requests not needed.");
        }

        @Override
        protected boolean isResponseForRequest(ClientResponse response) {
            return response.requestHeader().apiKey() == ApiKeys.INITIALIZE_SHARE_GROUP_STATE;
        }

        @Override
        protected void handleRequestResponse(ClientResponse response) {
            this.log.debug("Initialize state response received - {}", (Object)response);
            this.initializeStateBackoff.incrementAttempt();
            InitializeShareGroupStateResponse combinedResponse = (InitializeShareGroupStateResponse)response.responseBody();
            for (InitializeShareGroupStateResponseData.InitializeStateResult initializeStateResult : combinedResponse.data().results()) {
                Optional<InitializeShareGroupStateResponseData.PartitionResult> partitionStateData;
                if (!initializeStateResult.topicId().equals((Object)this.partitionKey().topicId()) || !(partitionStateData = initializeStateResult.partitions().stream().filter(partitionResult -> partitionResult.partition() == this.partitionKey().partition()).findFirst()).isPresent()) continue;
                Errors error = Errors.forCode((short)partitionStateData.get().errorCode());
                switch (error) {
                    case NONE: {
                        this.initializeStateBackoff.resetAttempts();
                        InitializeShareGroupStateResponseData.InitializeStateResult result = InitializeShareGroupStateResponse.toResponseInitializeStateResult((Uuid)this.partitionKey().topicId(), List.of(partitionStateData.get()));
                        this.result.complete(new InitializeShareGroupStateResponse(new InitializeShareGroupStateResponseData().setResults(List.of(result))));
                        return;
                    }
                    case COORDINATOR_NOT_AVAILABLE: 
                    case COORDINATOR_LOAD_IN_PROGRESS: 
                    case NOT_COORDINATOR: {
                        this.log.warn("Received retriable error in initialize state RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                        if (!this.initializeStateBackoff.canAttempt()) {
                            this.log.error("Exhausted max retries for initialize state RPC for key {} without success.", (Object)this.partitionKey());
                            this.requestErrorResponse(error, new Exception("Exhausted max retries to complete initialize state RPC without success."));
                            return;
                        }
                        super.resetCoordinatorNode();
                        PersisterStateManager.this.timer.add(new PersisterTimerTask(this.initializeStateBackoff.backOff(), this));
                        return;
                    }
                }
                this.log.error("Unable to perform initialize state RPC for key {}: {}", (Object)this.partitionKey(), (Object)error.message());
                this.requestErrorResponse(error, null);
                return;
            }
            IllegalStateException exception = new IllegalStateException("Failed to initialize state for share partition: " + String.valueOf(this.partitionKey()));
            this.requestErrorResponse(Errors.forException((Throwable)exception), exception);
        }

        @Override
        public void requestErrorResponse(Errors error, Exception exception) {
            this.result.complete(new InitializeShareGroupStateResponse(InitializeShareGroupStateResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in initialize state RPC. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        @Override
        protected void findCoordinatorErrorResponse(Errors error, Exception exception) {
            this.result.complete(new InitializeShareGroupStateResponse(InitializeShareGroupStateResponse.toErrorResponseData((Uuid)this.partitionKey().topicId(), (int)this.partitionKey().partition(), (Errors)error, (String)("Error in find coordinator. " + (exception == null ? error.message() : exception.getMessage())))));
        }

        protected CompletableFuture<InitializeShareGroupStateResponse> result() {
            return this.result;
        }

        @Override
        protected boolean isBatchable() {
            return true;
        }

        @Override
        protected RPCType rpcType() {
            return RPCType.INITIALIZE;
        }
    }

    public static enum RPCType {
        INITIALIZE,
        READ,
        WRITE,
        DELETE,
        SUMMARY,
        UNKNOWN;

    }

    private static class BackoffManager {
        private final int maxAttempts;
        private int attempts;
        private final ExponentialBackoff backoff;

        BackoffManager(int maxAttempts, long initialBackoffMs, long maxBackoffMs) {
            this.maxAttempts = maxAttempts;
            this.backoff = new ExponentialBackoff(initialBackoffMs, 2, maxBackoffMs, 0.2);
        }

        void incrementAttempt() {
            ++this.attempts;
        }

        void resetAttempts() {
            this.attempts = 0;
        }

        boolean canAttempt() {
            return this.attempts < this.maxAttempts;
        }

        long backOff() {
            return this.backoff.backoff((long)this.attempts);
        }
    }
}

