/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel;

import com.google.api.expr.v1alpha1.CheckedExpr;
import com.google.api.expr.v1alpha1.Expr;
import com.google.api.expr.v1alpha1.ParsedExpr;
import com.google.api.expr.v1alpha1.SourceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.projectnessie.cel.Ast;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.EvalOption;
import org.projectnessie.cel.Prog;
import org.projectnessie.cel.ProgFactory;
import org.projectnessie.cel.ProgGen;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.common.Source;
import org.projectnessie.cel.interpreter.Activation;
import org.projectnessie.cel.interpreter.AttributeFactory;
import org.projectnessie.cel.interpreter.AttributePattern;
import org.projectnessie.cel.interpreter.Coster;
import org.projectnessie.cel.interpreter.Dispatcher;
import org.projectnessie.cel.interpreter.EvalState;
import org.projectnessie.cel.interpreter.InterpretableDecorator;
import org.projectnessie.cel.interpreter.Interpreter;
import org.projectnessie.cel.parser.Unparser;

public final class CEL {
    public static Program newProgram(Env e, Ast ast, ProgramOption ... opts) {
        ProgFactory factory;
        Interpreter interp;
        Dispatcher disp = Dispatcher.newDispatcher();
        Prog p = new Prog(e, disp);
        for (ProgramOption opt : opts) {
            if (opt == null) {
                throw new NullPointerException("program options should be non-nil");
            }
            if ((p = opt.apply(p)) != null) continue;
            throw new NullPointerException(String.format("program option of type '%s' returned null", opt.getClass().getName()));
        }
        p.attrFactory = p.evalOpts.contains((Object)EvalOption.OptPartialEval) ? AttributePattern.newPartialAttributeFactory(e.getContainer(), e.getTypeAdapter(), e.getTypeProvider()) : AttributeFactory.newAttributeFactory(e.getContainer(), e.getTypeAdapter(), e.getTypeProvider());
        p.interpreter = interp = Interpreter.newInterpreter(disp, e.getContainer(), e.getTypeProvider(), e.getTypeAdapter(), p.attrFactory);
        ArrayList<InterpretableDecorator> decorators = new ArrayList<InterpretableDecorator>(p.decorators);
        if (p.evalOpts.contains((Object)EvalOption.OptOptimize)) {
            decorators.add(Interpreter.optimize());
        }
        Prog pp = p;
        if (p.evalOpts.contains((Object)EvalOption.OptExhaustiveEval)) {
            factory = state -> {
                ArrayList<InterpretableDecorator> decs = new ArrayList<InterpretableDecorator>(decorators);
                decs.add(Interpreter.exhaustiveEval(state));
                Prog clone = new Prog(e, pp.evalOpts, pp.defaultVars, disp, interp, state);
                return CEL.initInterpretable(clone, ast, decs);
            };
            return CEL.initProgGen(factory);
        }
        if (p.evalOpts.contains((Object)EvalOption.OptTrackState)) {
            factory = state -> {
                ArrayList<InterpretableDecorator> decs = new ArrayList<InterpretableDecorator>(decorators);
                decs.add(Interpreter.trackState(state));
                Prog clone = new Prog(e, pp.evalOpts, pp.defaultVars, disp, interp, state);
                return CEL.initInterpretable(clone, ast, decs);
            };
            return CEL.initProgGen(factory);
        }
        return CEL.initInterpretable(p, ast, decorators);
    }

    private static Program initProgGen(ProgFactory factory) {
        factory.apply(EvalState.newEvalState());
        return new ProgGen(factory);
    }

    private static Program initInterpretable(Prog p, Ast ast, List<InterpretableDecorator> decorators) {
        InterpretableDecorator[] decs = decorators.toArray(new InterpretableDecorator[0]);
        if (!ast.isChecked()) {
            p.interpretable = p.interpreter.newUncheckedInterpretable(ast.getExpr(), decs);
            return p;
        }
        CheckedExpr checked = CEL.astToCheckedExpr(ast);
        p.interpretable = p.interpreter.newInterpretable(checked, decs);
        return p;
    }

    public static Ast checkedExprToAst(CheckedExpr checkedExpr) {
        Map refMap = checkedExpr.getReferenceMapMap();
        Map typeMap = checkedExpr.getTypeMapMap();
        return new Ast(checkedExpr.getExpr(), checkedExpr.getSourceInfo(), Source.newInfoSource(checkedExpr.getSourceInfo()), refMap, typeMap);
    }

    public static CheckedExpr astToCheckedExpr(Ast a) {
        if (!a.isChecked()) {
            throw new IllegalArgumentException("cannot convert unchecked ast");
        }
        return CheckedExpr.newBuilder().setExpr(a.getExpr()).setSourceInfo(a.getSourceInfo()).putAllReferenceMap(a.refMap).putAllTypeMap(a.typeMap).build();
    }

    public static Ast parsedExprToAst(ParsedExpr parsedExpr) {
        SourceInfo si = parsedExpr.getSourceInfo();
        return new Ast(parsedExpr.getExpr(), si, Source.newInfoSource(si));
    }

    public static ParsedExpr astToParsedExpr(Ast a) {
        return ParsedExpr.newBuilder().setExpr(a.getExpr()).setSourceInfo(a.getSourceInfo()).build();
    }

    public static String astToString(Ast a) {
        Expr expr = a.getExpr();
        SourceInfo info = a.getSourceInfo();
        return Unparser.unparse(expr, info);
    }

    public static Activation noVars() {
        return Activation.emptyActivation();
    }

    public static Activation.PartialActivation partialVars(Object vars, AttributePattern ... unknowns) {
        return Activation.newPartialActivation(vars, unknowns);
    }

    public static AttributePattern attributePattern(String varName) {
        return AttributePattern.newAttributePattern(varName);
    }

    public static Coster.Cost estimateCost(Object p) {
        if (p instanceof Coster) {
            return ((Coster)p).cost();
        }
        return Coster.Cost.Unknown;
    }
}

