/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.checker;

import com.google.api.expr.v1alpha1.Type;
import java.util.List;
import org.projectnessie.cel.checker.Types;
import org.projectnessie.cel.common.Errors;
import org.projectnessie.cel.common.Location;
import org.projectnessie.cel.common.Source;

public final class TypeErrors
extends Errors {
    public TypeErrors(Source source) {
        super(source);
    }

    void undeclaredReference(Location l, String container, String name) {
        this.reportError(l, "undeclared reference to '%s' (in container '%s')", name, container);
    }

    void expressionDoesNotSelectField(Location l) {
        this.reportError(l, "expression does not select a field", new Object[0]);
    }

    void typeDoesNotSupportFieldSelection(Location l, Type t) {
        this.reportError(l, "type '%s' does not support field selection", Types.formatCheckedType(t));
    }

    void undefinedField(Location l, String field) {
        this.reportError(l, "undefined field '%s'", field);
    }

    void fieldDoesNotSupportPresenceCheck(Location l, String field) {
        this.reportError(l, "field '%s' does not support presence check", field);
    }

    void overlappingOverload(Location l, String name, String overloadID1, Type f1, String overloadID2, Type f2) {
        this.reportError(l, "overlapping overload for name '%s' (type '%s' with overloadId: '%s' cannot be distinguished from '%s' with overloadId: '%s')", name, Types.formatCheckedType(f1), overloadID1, Types.formatCheckedType(f2), overloadID2);
    }

    void overlappingMacro(Location l, String name, int args) {
        this.reportError(l, "overload for name '%s' with %d argument(s) overlaps with predefined macro", name, args);
    }

    void noMatchingOverload(Location l, String name, List<Type> args, boolean isInstance) {
        String signature = TypeErrors.formatFunction(null, args, isInstance);
        this.reportError(l, "found no matching overload for '%s' applied to '%s'", name, signature);
    }

    void aggregateTypeMismatch(Location l, Type aggregate, Type member) {
        this.reportError(l, "type '%s' does not match previous type '%s' in aggregate. Use 'dyn(x)' to make the aggregate dynamic.", Types.formatCheckedType(member), Types.formatCheckedType(aggregate));
    }

    void notAType(Location l, Type t) {
        this.reportError(l, "'%s' is not a type", Types.formatCheckedType(t), t);
    }

    void notAMessageType(Location l, Type t) {
        this.reportError(l, "'%s' is not a message type", Types.formatCheckedType(t));
    }

    void fieldTypeMismatch(Location l, String name, Type field, Type value) {
        this.reportError(l, "expected type of field '%s' is '%s' but provided type is '%s'", name, Types.formatCheckedType(field), Types.formatCheckedType(value));
    }

    void unexpectedFailedResolution(Location l, String typeName) {
        this.reportError(l, "[internal] unexpected failed resolution of '%s'", typeName);
    }

    void notAComprehensionRange(Location l, Type t) {
        this.reportError(l, "expression of type '%s' cannot be range of a comprehension (must be list, map, or dynamic)", Types.formatCheckedType(t));
    }

    void typeMismatch(Location l, Type expected, Type actual) {
        this.reportError(l, "expected type '%s' but found '%s'", Types.formatCheckedType(expected), Types.formatCheckedType(actual));
    }

    public void unknownType(Location l, String info) {
    }

    static String formatFunction(Type resultType, List<Type> argTypes, boolean isInstance) {
        StringBuilder result = new StringBuilder();
        TypeErrors.formatFunction(result, resultType, argTypes, isInstance);
        return result.toString();
    }

    static void formatFunction(StringBuilder result, Type resultType, List<Type> argTypes, boolean isInstance) {
        if (isInstance) {
            Type target = argTypes.get(0);
            argTypes = argTypes.subList(1, argTypes.size());
            Types.formatCheckedType(result, target);
            result.append(".");
        }
        result.append("(");
        for (int i = 0; i < argTypes.size(); ++i) {
            Type arg = argTypes.get(i);
            if (i > 0) {
                result.append(", ");
            }
            Types.formatCheckedType(result, arg);
        }
        result.append(")");
        if (resultType != null) {
            result.append(" -> ");
            Types.formatCheckedType(result, resultType);
        }
    }
}

