/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import com.google.protobuf.Any;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.IteratorT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Lister;
import org.projectnessie.cel.common.types.traits.Trait;

public abstract class ListT
extends BaseVal
implements Lister {
    public static final Type ListType = TypeT.newTypeValue(TypeEnum.List, Trait.AdderType, Trait.ContainerType, Trait.IndexerType, Trait.IterableType, Trait.SizerType);

    public static Val newStringArrayList(String[] value) {
        return ListT.newGenericArrayList(v -> StringT.stringOf((String)v), value);
    }

    public static Val newGenericArrayList(TypeAdapter adapter, Object[] value) {
        return new GenericListT(adapter, value);
    }

    public static Val newValArrayList(TypeAdapter adapter, Val[] value) {
        return new ValListT(adapter, value);
    }

    @Override
    public Type type() {
        return ListType;
    }

    public static Val newJSONList(TypeAdapter adapter, ListValue l) {
        List vals = l.getValuesList();
        return ListT.newGenericArrayList(adapter, vals.toArray());
    }

    static final class GenericListT
    extends BaseListT {
        private final Object[] array;

        GenericListT(TypeAdapter adapter, Object[] array) {
            super(adapter, array.length);
            this.array = array;
        }

        @Override
        public Object value() {
            return this.array;
        }

        @Override
        public Val add(Val other) {
            if (!(other instanceof Lister)) {
                return Err.noSuchOverload(this, "add", other);
            }
            Lister otherList = (Lister)other;
            Object[] otherArray = (Object[])otherList.value();
            Object[] newArray = Arrays.copyOf(this.array, this.array.length + otherArray.length);
            System.arraycopy(otherArray, 0, newArray, this.array.length, otherArray.length);
            return new GenericListT(this.adapter, newArray);
        }

        @Override
        public Val get(Val index) {
            switch (index.type().typeEnum()) {
                case Int: 
                case Uint: {
                    break;
                }
                case Double: {
                    double od = index.doubleValue();
                    if (Math.rint(od) == od) break;
                    return Err.newErr("invalid_argument", new Object[0]);
                }
                default: {
                    return Err.valOrErr(index, "unsupported index type '%s' in list", index.type());
                }
            }
            int sz = this.array.length;
            int i = (int)index.intValue();
            if (i < 0 || i >= sz) {
                return Err.newErr("invalid_argument: index '%d' out of range in list of size '%d'", i, sz);
            }
            return this.adapter.nativeToValue(this.array[i]);
        }

        @Override
        public String toString() {
            return "GenericListT{array=" + Arrays.toString(this.array) + ", adapter=" + this.adapter + ", size=" + this.size + '}';
        }
    }

    static final class ValListT
    extends BaseListT {
        private final Val[] array;

        ValListT(TypeAdapter adapter, Val[] array) {
            super(adapter, array.length);
            this.array = array;
        }

        @Override
        public Object value() {
            Object[] nativeArray = new Object[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                nativeArray[i] = this.array[i].value();
            }
            return nativeArray;
        }

        @Override
        public Val add(Val other) {
            if (!(other instanceof Lister)) {
                return Err.noSuchOverload(this, "add", other);
            }
            if (other instanceof ValListT) {
                Val[] otherArray = ((ValListT)other).array;
                Val[] newArray = Arrays.copyOf(this.array, this.array.length + otherArray.length);
                System.arraycopy(otherArray, 0, newArray, this.array.length, otherArray.length);
                return new ValListT(this.adapter, newArray);
            }
            Lister otherLister = (Lister)other;
            int otherSIze = (int)otherLister.size().intValue();
            Val[] newArray = Arrays.copyOf(this.array, this.array.length + otherSIze);
            for (int i = 0; i < otherSIze; ++i) {
                newArray[this.array.length + i] = otherLister.get(IntT.intOf(i));
            }
            return new ValListT(this.adapter, newArray);
        }

        @Override
        public Val get(Val index) {
            switch (index.type().typeEnum()) {
                case Int: 
                case Uint: {
                    break;
                }
                case Double: {
                    double od = index.doubleValue();
                    if (Math.rint(od) == od) break;
                    return Err.newErr("invalid_argument", new Object[0]);
                }
                default: {
                    return Err.valOrErr(index, "unsupported index type '%s' in list", index.type());
                }
            }
            int sz = this.array.length;
            int i = (int)index.intValue();
            if (i < 0 || i >= sz) {
                return Err.newErr("invalid_argument: index '%d' out of range in list of size '%d'", i, sz);
            }
            return this.array[i];
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValListT valListT = (ValListT)o;
            return Arrays.equals(this.array, valListT.array);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.array);
            return result;
        }

        @Override
        public String toString() {
            return "ValListT{array=" + Arrays.toString(this.array) + ", adapter=" + this.adapter + ", size=" + this.size + '}';
        }
    }

    static abstract class BaseListT
    extends ListT {
        protected final TypeAdapter adapter;
        protected final long size;

        BaseListT(TypeAdapter adapter, long size) {
            this.adapter = adapter;
            this.size = size;
        }

        @Override
        public <T> T convertToNative(Class<T> typeDesc) {
            if (typeDesc.isArray()) {
                Object array = this.toJavaArray(typeDesc);
                return (T)array;
            }
            if (typeDesc == List.class || typeDesc == Object.class) {
                return (T)this.toJavaList();
            }
            if (typeDesc == ListValue.class) {
                return (T)this.toPbListValue();
            }
            if (typeDesc == Value.class) {
                return (T)this.toPbValue();
            }
            if (typeDesc == Any.class) {
                ListValue v = this.toPbListValue();
                return (T)Any.newBuilder().setTypeUrl("type.googleapis.com/google.protobuf.ListValue").setValue(v.toByteString()).build();
            }
            throw new IllegalArgumentException(String.format("Unsupported conversion of '%s' to '%s'", ListType, typeDesc.getName()));
        }

        private Value toPbValue() {
            return Value.newBuilder().setListValue(this.toPbListValue()).build();
        }

        private ListValue toPbListValue() {
            ListValue.Builder list = ListValue.newBuilder();
            int s = (int)this.size;
            for (int i = 0; i < s; ++i) {
                Val v = this.get(IntT.intOf(i));
                Value e = v.convertToNative(Value.class);
                list.addValues(e);
            }
            return list.build();
        }

        private List<Object> toJavaList() {
            return Arrays.asList(this.convertToNative(Object[].class));
        }

        private <T> Object toJavaArray(Class<T> typeDesc) {
            int s = (int)this.size;
            Class<Object> compType = typeDesc.getComponentType();
            if (compType == Enum.class) {
                compType = Object.class;
            }
            Object array = Array.newInstance(compType, s);
            Function<?, ?> fixForTarget = Function.identity();
            for (int i = 0; i < s; ++i) {
                Val v = this.get(IntT.intOf(i));
                Object e = v.convertToNative(compType);
                e = fixForTarget.apply(e);
                Array.set(array, i, e);
            }
            return array;
        }

        @Override
        public Val convertToType(Type typeValue) {
            switch (typeValue.typeEnum()) {
                case List: {
                    return this;
                }
                case Type: {
                    return ListType;
                }
            }
            return Err.newTypeConversionError(ListType, typeValue);
        }

        @Override
        public IteratorT iterator() {
            return new ArrayListIteratorT();
        }

        @Override
        public Val equal(Val other) {
            if (other.type() != ListType) {
                return BoolT.False;
            }
            ListT o = (ListT)other;
            if (this.size != o.size().intValue()) {
                return BoolT.False;
            }
            for (long i = 0L; i < this.size; ++i) {
                IntT idx = IntT.intOf(i);
                Val e1 = this.get(idx);
                if (Err.isError(e1)) {
                    return e1;
                }
                Val e2 = o.get(idx);
                if (Err.isError(e2)) {
                    return e2;
                }
                if (!e1.type().equals(e2.type()) && (e2 = e2.convertToType(e2.type())).type().typeEnum() == TypeEnum.Err) {
                    return Err.noSuchOverload(e1, Operator.Equals.id, e2);
                }
                if (e1.equal(e2) == BoolT.True) continue;
                return BoolT.False;
            }
            return BoolT.True;
        }

        @Override
        public Val contains(Val value) {
            for (long i = 0L; i < this.size; ++i) {
                Val elem = this.get(IntT.intOf(i));
                if (value.equal(elem) != BoolT.True) continue;
                return BoolT.True;
            }
            return BoolT.False;
        }

        @Override
        public Val size() {
            return IntT.intOf(this.size);
        }

        private final class ArrayListIteratorT
        extends BaseVal
        implements IteratorT {
            private long index;

            private ArrayListIteratorT() {
            }

            @Override
            public Val hasNext() {
                return Types.boolOf(this.index < BaseListT.this.size);
            }

            @Override
            public Val next() {
                if (this.index < BaseListT.this.size) {
                    return BaseListT.this.get(IntT.intOf(this.index++));
                }
                return Err.noMoreElements();
            }

            @Override
            public <T> T convertToNative(Class<T> typeDesc) {
                throw new UnsupportedOperationException("IMPLEMENT ME??");
            }

            @Override
            public Val convertToType(Type typeValue) {
                throw new UnsupportedOperationException("IMPLEMENT ME??");
            }

            @Override
            public Val equal(Val other) {
                throw new UnsupportedOperationException("IMPLEMENT ME??");
            }

            @Override
            public Type type() {
                throw new UnsupportedOperationException("IMPLEMENT ME??");
            }

            @Override
            public Object value() {
                throw new UnsupportedOperationException("IMPLEMENT ME??");
            }
        }
    }
}

