/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types.pb;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.projectnessie.cel.common.types.pb.EnumValueDescription;
import org.projectnessie.cel.common.types.pb.FileDescription;
import org.projectnessie.cel.common.types.pb.PbTypeDescription;

public final class Db {
    private final Map<String, FileDescription> revFileDescriptorMap;
    private final List<FileDescription> files;
    public static final Db defaultDb = new Db(new HashMap<String, FileDescription>(), new ArrayList<FileDescription>());

    private Db(Map<String, FileDescription> revFileDescriptorMap, List<FileDescription> files) {
        this.revFileDescriptorMap = revFileDescriptorMap;
        this.files = files;
    }

    public static Db newDb() {
        return defaultDb.copy();
    }

    public Db copy() {
        HashMap<String, FileDescription> revFileDescriptorMap = new HashMap<String, FileDescription>(this.revFileDescriptorMap);
        ArrayList<FileDescription> files = new ArrayList<FileDescription>(this.files);
        return new Db(revFileDescriptorMap, files);
    }

    public List<FileDescription> fileDescriptions() {
        return this.files;
    }

    public FileDescription registerDescriptor(Descriptors.FileDescriptor fileDesc) {
        String path = this.path(fileDesc);
        FileDescription fd = this.revFileDescriptorMap.get(path);
        if (fd != null) {
            return fd;
        }
        fd = FileDescription.newFileDescription(fileDesc);
        for (String enumValName : fd.getEnumNames()) {
            this.revFileDescriptorMap.put(enumValName, fd);
        }
        for (String msgTypeName : fd.getTypeNames()) {
            this.revFileDescriptorMap.put(msgTypeName, fd);
        }
        this.revFileDescriptorMap.put(path, fd);
        this.files.add(fd);
        return fd;
    }

    private String path(Descriptors.FileDescriptor fileDesc) {
        return fileDesc.getPackage() + ':' + fileDesc.getFullName();
    }

    public FileDescription registerMessage(Message message) {
        Descriptors.Descriptor msgDesc = message.getDescriptorForType();
        String msgName = msgDesc.getFullName();
        String typeName = FileDescription.sanitizeProtoName(msgName);
        FileDescription fd = this.revFileDescriptorMap.get(typeName);
        if (fd == null) {
            fd = this.registerDescriptor(msgDesc.getFile());
            this.revFileDescriptorMap.put(typeName, fd);
        }
        this.describeType(typeName).updateReflectType(message);
        return fd;
    }

    public EnumValueDescription describeEnum(String enumName) {
        FileDescription fd = this.revFileDescriptorMap.get(enumName = FileDescription.sanitizeProtoName(enumName));
        return fd != null ? fd.getEnumDescription(enumName) : null;
    }

    public PbTypeDescription describeType(String typeName) {
        FileDescription fd = this.revFileDescriptorMap.get(typeName = FileDescription.sanitizeProtoName(typeName));
        return fd != null ? fd.getTypeDescription(typeName) : null;
    }

    public static Set<Descriptors.FileDescriptor> collectFileDescriptorSet(Message message) {
        LinkedHashSet<Descriptors.FileDescriptor> fdMap = new LinkedHashSet<Descriptors.FileDescriptor>();
        Descriptors.Descriptor messageDesc = message.getDescriptorForType();
        Descriptors.FileDescriptor messageFile = messageDesc.getFile();
        fdMap.add(messageFile);
        fdMap.addAll(messageFile.getPublicDependencies());
        return fdMap;
    }

    public String toString() {
        return "Db{revFileDescriptorMap.size=" + this.revFileDescriptorMap.size() + ", files=" + this.files.size() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Db db = (Db)o;
        return Objects.equals(this.revFileDescriptorMap, db.revFileDescriptorMap) && Objects.equals(this.files, db.files);
    }

    public int hashCode() {
        return Objects.hash(this.revFileDescriptorMap, this.files);
    }

    static {
        defaultDb.registerMessage((Message)Any.getDefaultInstance());
        defaultDb.registerMessage((Message)Duration.getDefaultInstance());
        defaultDb.registerMessage((Message)Empty.getDefaultInstance());
        defaultDb.registerMessage((Message)Timestamp.getDefaultInstance());
        defaultDb.registerMessage((Message)Value.getDefaultInstance());
        defaultDb.registerMessage((Message)BoolValue.getDefaultInstance());
    }
}

