/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.function.sdk.v1;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.function.sdk.v1.AuthTokenProvider;
import io.confluent.function.sdk.v1.RequestUtils;
import io.confluent.function.sdk.v1.types.CfltFunction;
import io.confluent.function.sdk.v1.types.CfltFunctionPool;
import io.confluent.function.sdk.v1.types.CfltFunctionPoolSpec;
import io.confluent.function.sdk.v1.types.CfltFunctionSpec;
import io.confluent.function.sdk.v1.types.ObjectMetadata;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CfltFunctionManagementClient
implements Closeable {
    private final Logger logger = Logger.getLogger(CfltFunctionManagementClient.class.getName());
    private final String apiServerEndpoint;
    private final AuthTokenProvider authTokenProvider;
    private final HttpClient httpClient;
    private final ObjectMapper mapper;

    CfltFunctionManagementClient(String apiServerEndpoint, AuthTokenProvider authTokenProvider, HttpClient httpClient) {
        this.apiServerEndpoint = apiServerEndpoint;
        this.authTokenProvider = authTokenProvider;
        this.httpClient = httpClient;
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public void createCfltFunction(ObjectMetadata funcMetadata, CfltFunctionSpec funcSpec) throws IOException, InterruptedException {
        this.internalCreateCfltFunction(funcMetadata, funcSpec);
    }

    public void deleteCfltFunction(ObjectMetadata funcMetadata) throws IOException, InterruptedException {
        this.internalDeleteCfltFunction(funcMetadata);
    }

    public CfltFunction getCfltFunction(ObjectMetadata funcMetadata) throws IOException, InterruptedException {
        HttpResponse<String> resp = this.internalGetCfltFunction(funcMetadata);
        if (resp.statusCode() != 200) {
            throw new IOException("failed to retrieve cflt function: statusCode=" + resp.statusCode());
        }
        CfltFunction cfltFunction = (CfltFunction)this.mapper.readValue(resp.body(), CfltFunction.class);
        String phase = cfltFunction.getStatus().getPhase();
        String invocationEndpoint = cfltFunction.getStatus().getEndpoint().getHost() + ":" + cfltFunction.getStatus().getEndpoint().getPort();
        this.logger.log(Level.FINE, "getCfltFunction: func={0}, statusCode={1}, phase={2}, endpoint={3}", new Object[]{funcMetadata, resp.statusCode(), phase, invocationEndpoint});
        return cfltFunction;
    }

    public void createCfltFunctionPool(ObjectMetadata poolMetadata, CfltFunctionPoolSpec poolSpec) throws IOException, InterruptedException {
        this.internalCreateCfltFunctionPool(poolMetadata, poolSpec);
    }

    public void deleteCfltFunctionPool(ObjectMetadata poolMetadata) throws IOException, InterruptedException {
        this.internalDeleteCfltFunctionPool(poolMetadata);
    }

    public CfltFunctionPool getCfltFunctionPool(ObjectMetadata poolMetadata) throws IOException, InterruptedException {
        HttpResponse<String> resp = this.internalGetCfltFunctionPool(poolMetadata);
        if (resp.statusCode() != 200) {
            throw new IOException("failed to retrieve cflt function pool: statusCode=" + resp.statusCode());
        }
        CfltFunctionPool cfltFunctionPool = (CfltFunctionPool)this.mapper.readValue(resp.body(), CfltFunctionPool.class);
        this.logger.log(Level.FINE, "getCfltFunctionPool: pool={0}, statusCode={1}, endpoint={3}", new Object[]{poolMetadata, resp.statusCode(), this.apiServerEndpoint});
        return cfltFunctionPool;
    }

    private void internalCreateCfltFunction(ObjectMetadata funcMetadata, CfltFunctionSpec funcSpec) throws IOException, InterruptedException {
        HttpResponse<String> resp = this.internalGetCfltFunction(funcMetadata);
        if (resp.statusCode() != 404) {
            this.logger.log(Level.FINE, "internalGetCfltFunction: func={0}, statusCode={1}, endpoint={2}", new Object[]{funcMetadata, resp.statusCode(), this.apiServerEndpoint});
            throw new IOException("already exists");
        }
        boolean created = false;
        for (int i = 0; i < 3; ++i) {
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.apiServerEndpoint + RequestUtils.buildCreateOrListCfltFunctionApiUrlPath(funcMetadata))).headers(this.getRequestHeaders()).POST(HttpRequest.BodyPublishers.ofString(RequestUtils.buildCreateCfltFunctionRequestPayload(funcMetadata, funcSpec))).build();
            HttpResponse<String> resp2 = this.httpClient.send(req, HttpResponse.BodyHandlers.ofString());
            this.logger.log(Level.FINE, "internalCreateCfltFunction: func={0}, statusCode={1}, endpoint={2}", new Object[]{funcMetadata, resp2.statusCode(), this.apiServerEndpoint});
            if (resp2.statusCode() != 409 && (resp2.statusCode() < 200 || resp2.statusCode() >= 300)) continue;
            created = true;
            break;
        }
        if (!created) {
            throw new IOException("failed to create cflt function after retries");
        }
        this.internalEnsureCfltFunctionCreated(funcMetadata);
    }

    private void internalEnsureCfltFunctionCreated(ObjectMetadata funcMetadata) throws IOException, InterruptedException {
        for (int i = 0; i < 30; ++i) {
            Thread.sleep(1000L);
            HttpResponse<String> resp = this.internalGetCfltFunction(funcMetadata);
            this.logger.log(Level.FINE, "internalEnsureCfltFunctionCreated: func={0}, statusCode={1}, endpoint={2}", new Object[]{funcMetadata, resp.statusCode(), this.apiServerEndpoint});
            if (resp.statusCode() >= 400 && resp.statusCode() < 500) {
                throw new IOException("Failed to create cflt function: response=" + String.valueOf(resp));
            }
            if (resp.statusCode() >= 500) continue;
            CfltFunction cfltFunction = (CfltFunction)this.mapper.readValue(resp.body(), CfltFunction.class);
            String phase = cfltFunction.getStatus().getPhase();
            this.logger.log(Level.FINE, "internalEnsureCfltFunctionCreated: func={0}, status.phase={1}, endpoint={2}", new Object[]{funcMetadata, phase, this.apiServerEndpoint});
            if ("Running".equalsIgnoreCase(phase) || "Ready".equalsIgnoreCase(phase)) {
                return;
            }
            if ("Pending".equalsIgnoreCase(phase)) continue;
            throw new IOException("Failed to ready cflt function: unexpected phase = " + phase);
        }
        throw new IOException("Failed to ready cflt function after wait");
    }

    private void internalDeleteCfltFunction(ObjectMetadata funcMetadata) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newBuilder().build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiServerEndpoint + RequestUtils.buildCfltFunctionApiUrlPath(funcMetadata))).headers(this.getRequestHeaders()).DELETE().build();
        HttpResponse<String> resp = client.send(request, HttpResponse.BodyHandlers.ofString());
        this.logger.log(Level.FINE, "internalDeleteCfltFunction: func={0}, statusCode={1}, endpoint={2}", new Object[]{funcMetadata, resp.statusCode(), this.apiServerEndpoint});
        if (resp.statusCode() == 404) {
            return;
        }
        if (resp.statusCode() < 200 || resp.statusCode() >= 300) {
            throw new IOException("Failed to delete cflt function: response=" + String.valueOf(resp));
        }
        this.internalEnsureCfltFunctionDeleted(funcMetadata);
    }

    private void internalEnsureCfltFunctionDeleted(ObjectMetadata funcMetadata) throws IOException, InterruptedException {
        for (int i = 0; i < 30; ++i) {
            Thread.sleep(1000L);
            HttpResponse<String> resp = this.internalGetCfltFunction(funcMetadata);
            this.logger.log(Level.FINE, "internalEnsureCfltFunctionDeleted: func={0}, statusCode={1}, endpoint={2}", new Object[]{funcMetadata, resp.statusCode(), this.apiServerEndpoint});
            if (resp.statusCode() == 404) {
                return;
            }
            if (resp.statusCode() >= 400 && resp.statusCode() < 500) {
                throw new IOException("Failed to delete cflt function: response=" + String.valueOf(resp));
            }
            if (resp.statusCode() >= 500) continue;
            CfltFunction cfltFunction = (CfltFunction)this.mapper.readValue(resp.body(), CfltFunction.class);
            String phase = cfltFunction.getStatus().getPhase();
            this.logger.log(Level.FINE, "internalEnsureCfltFunctionDeleted: func={0}, status.phase={1}, endpoint={2}", new Object[]{funcMetadata, phase, this.apiServerEndpoint});
        }
        throw new IOException("Failed to fully delete cflt function after wait");
    }

    private HttpResponse<String> internalGetCfltFunction(ObjectMetadata funcMetadata) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiServerEndpoint + RequestUtils.buildCfltFunctionApiUrlPath(funcMetadata))).headers(this.getRequestHeaders()).GET().build();
        return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
    }

    private void internalCreateCfltFunctionPool(ObjectMetadata poolMetadata, CfltFunctionPoolSpec poolSpec) throws IOException, InterruptedException {
        HttpResponse<String> resp = this.internalGetCfltFunctionPool(poolMetadata);
        if (resp.statusCode() != 404) {
            this.logger.log(Level.FINE, "internalGetCfltFunctionPool: pool={0}, statusCode={1}, endpoint={2}", new Object[]{poolMetadata, resp.statusCode(), this.apiServerEndpoint});
            throw new IOException("already exists");
        }
        boolean created = false;
        for (int i = 0; i < 3; ++i) {
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.apiServerEndpoint + RequestUtils.buildCreateOrListCfltFunctionPoolApiUrlPath(poolMetadata))).headers(this.getRequestHeaders()).POST(HttpRequest.BodyPublishers.ofString(RequestUtils.buildCreateCfltFunctionPoolRequestPayload(poolMetadata, poolSpec))).build();
            HttpResponse<String> resp2 = this.httpClient.send(req, HttpResponse.BodyHandlers.ofString());
            this.logger.log(Level.FINE, "internalCreateCfltFunctionPool: pool={0}, statusCode={1}, endpoint={2}", new Object[]{poolMetadata, resp2.statusCode(), this.apiServerEndpoint});
            if (resp2.statusCode() != 409 && (resp2.statusCode() < 200 || resp2.statusCode() >= 300)) continue;
            created = true;
            break;
        }
        if (!created) {
            throw new IOException("failed to create cflt function pool after retries");
        }
    }

    private void internalDeleteCfltFunctionPool(ObjectMetadata poolMetadata) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newBuilder().build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiServerEndpoint + RequestUtils.buildCfltFunctionPoolApiUrlPath(poolMetadata))).headers(this.getRequestHeaders()).DELETE().build();
        HttpResponse<String> resp = client.send(request, HttpResponse.BodyHandlers.ofString());
        this.logger.log(Level.FINE, "internalDeleteCfltFunctionPool: pool={0}, statusCode={1}, endpoint={2}", new Object[]{poolMetadata, resp.statusCode(), this.apiServerEndpoint});
        if (resp.statusCode() == 404) {
            return;
        }
        if (resp.statusCode() < 200 || resp.statusCode() >= 300) {
            throw new IOException("Failed to delete cflt function pool: response=" + String.valueOf(resp));
        }
    }

    private HttpResponse<String> internalGetCfltFunctionPool(ObjectMetadata poolMetadata) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newBuilder().build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiServerEndpoint + RequestUtils.buildCfltFunctionPoolApiUrlPath(poolMetadata))).headers(this.getRequestHeaders()).GET().build();
        return client.send(request, HttpResponse.BodyHandlers.ofString());
    }

    private String[] getRequestHeaders() {
        if (this.authTokenProvider == null) {
            return new String[]{"Content-Type", "application/json"};
        }
        return new String[]{"Content-Type", "application/json", "Authorization", "Bearer " + this.authTokenProvider.get()};
    }

    @Override
    public void close() {
    }
}

