/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.function.sdk.v1;

import io.confluent.function.sdk.v1.AuthTokenProvider;
import io.confluent.function.sdk.v1.CCloudEnv;
import io.confluent.function.sdk.v1.CfltFunctionManagementClient;
import io.confluent.function.sdk.v1.CloudRegion;
import java.net.http.HttpClient;

public class CfltFunctionManagementClientBuilder {
    private static final String resourceManagerEndpointInCluster = "http://api-server.resource-manager";
    private static final String controlPlaneGatewayServerEndpointLocal = "http://localhost:8080";
    private static final String controlPlaneGatewayServerEndpointDevel_AWS_US_WEST_2 = "https://securecompute-gateway.us-west-2.aws.intranet.devel.cpdev.cloud";
    private static final String controlPlaneGatewayServerEndpointStag_AWS_US_WEST_2 = "https://securecompute-gateway.us-west-2.aws.intranet.stag.cpdev.cloud";
    private static final String controlPlaneDevelPublicGatewayServerEndpoint = "http://a21a03708f2bb4b6abf41678779c7847-1648523723.us-west-2.elb.amazonaws.com:8000";
    private String clientId;
    private boolean useRegionalApiServer;
    private CloudRegion region;
    private AuthTokenProvider authTokenProvider;
    private boolean useExperimentalDevelPublicGateway;
    private CCloudEnv ccloudEnv;
    private String apiServerEndpoint;
    private HttpClient httpClient;

    public CfltFunctionManagementClientBuilder withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public CfltFunctionManagementClientBuilder useRegionalApiServer() {
        this.useRegionalApiServer = true;
        return this;
    }

    public CfltFunctionManagementClientBuilder withRegion(CloudRegion region) {
        this.region = region;
        return this;
    }

    public CfltFunctionManagementClientBuilder withAuthTokenProvider(AuthTokenProvider authTokenProvider) {
        this.authTokenProvider = authTokenProvider;
        return this;
    }

    public CfltFunctionManagementClientBuilder withCCloudEnv(CCloudEnv ccloudEnv) {
        this.ccloudEnv = ccloudEnv;
        return this;
    }

    public CfltFunctionManagementClientBuilder withExperimentalApiServerEndpoint(String apiServerEndpoint) {
        this.apiServerEndpoint = apiServerEndpoint;
        return this;
    }

    public CfltFunctionManagementClientBuilder useExperimentalDevelPublicGateway() {
        this.useExperimentalDevelPublicGateway = true;
        return this;
    }

    public CfltFunctionManagementClientBuilder withExperimentalHttpClient(HttpClient HttpClient2) {
        this.httpClient = this.httpClient;
        return this;
    }

    public String getControlPlaneApiServerEndpoint() {
        if (this.apiServerEndpoint != null) {
            return this.apiServerEndpoint;
        }
        if (this.useRegionalApiServer) {
            if (this.ccloudEnv == CCloudEnv.PROD) {
                return CloudRegion.getControlPlaneEndpoint(this.region);
            }
            if (this.ccloudEnv == CCloudEnv.STAG) {
                if (this.region == CloudRegion.AWS_US_WEST_2) {
                    return controlPlaneGatewayServerEndpointStag_AWS_US_WEST_2;
                }
            } else if (this.ccloudEnv == CCloudEnv.DEVEL) {
                if (this.useExperimentalDevelPublicGateway) {
                    return controlPlaneDevelPublicGatewayServerEndpoint;
                }
                if (this.region == CloudRegion.AWS_US_WEST_2) {
                    return controlPlaneGatewayServerEndpointDevel_AWS_US_WEST_2;
                }
            }
            return controlPlaneGatewayServerEndpointLocal;
        }
        return resourceManagerEndpointInCluster;
    }

    public CfltFunctionManagementClient build() {
        HttpClient httpClient = this.httpClient;
        if (httpClient == null) {
            httpClient = HttpClient.newBuilder().build();
        }
        return new CfltFunctionManagementClient(this.getControlPlaneApiServerEndpoint(), this.authTokenProvider, httpClient);
    }
}

