/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.function.sdk.v1.examples;

import com.google.protobuf.ByteString;
import io.confluent.function.sdk.v1.CfltFunctionClient;
import io.confluent.function.sdk.v1.CfltFunctionClientBuilder;
import io.confluent.function.sdk.v1.StaticAuthTokenProvider;
import io.confluent.function.sdk.v1.types.ObjectMetadata;
import io.confluent.secure.compute.function.runtime.v2.InvokeRequest;
import io.confluent.secure.compute.function.runtime.v2.InvokeRequestBatch;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CfltFunctionClientV2RoutingExample {
    private static final String dataPlaneGatewayMagicalAccessToken = System.getenv("DATA_PLANE_GATEWAY_MAGICAL_ACCESS_TOKEN");
    private static final String dataPlaneGatewayServerEndpoint = "a21a03708f2bb4b6abf41678779c7847-1648523723.us-west-2.elb.amazonaws.com:50051";

    public static void main(String[] args) throws IOException, InterruptedException {
        CfltFunctionClientV2RoutingExample.enableVerboseSdkLogging();
        ObjectMetadata funcMetadata = ObjectMetadata.builder().name("user-func-12345").org("e9eb4f2c-ef73-475c-ba7f-6b37a4ff00e5").environment("env-devc33qr20").build();
        try (CfltFunctionClient client = new CfltFunctionClientBuilder().withClientId("connect-custom-smt").withAuthTokenProvider(new StaticAuthTokenProvider(dataPlaneGatewayMagicalAccessToken)).useExperimentalDevelPublicGateway().withInvocationEndpoint(dataPlaneGatewayServerEndpoint).withFunctionMetadata(funcMetadata).useExperimentalV2Routing().build();){
            int i;
            for (i = 0; i < 5; ++i) {
                client.invoke(InvokeRequest.newBuilder().setPayload(ByteString.copyFromUtf8((String)("hello world - " + i))).build());
            }
            for (i = 0; i < 5; ++i) {
                client.invokeBatch(InvokeRequestBatch.newBuilder().addRequests(InvokeRequest.newBuilder().setPayload(ByteString.copyFromUtf8((String)"hello world-1")).build()).addRequests(InvokeRequest.newBuilder().setPayload(ByteString.copyFromUtf8((String)"hello world-2")).build()).addRequests(InvokeRequest.newBuilder().setPayload(ByteString.copyFromUtf8((String)"hello world-3")).build()).build());
            }
        }
    }

    private static void enableVerboseSdkLogging() {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(Level.ALL);
        }
        Logger.getLogger("io.confluent.function.sdk.v1").setLevel(Level.ALL);
    }
}

