/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.function.sdk.v1.examples;

import io.confluent.function.sdk.v1.CCloudEnv;
import io.confluent.function.sdk.v1.CfltFunctionManagementClient;
import io.confluent.function.sdk.v1.CfltFunctionManagementClientBuilder;
import io.confluent.function.sdk.v1.CloudRegion;
import io.confluent.function.sdk.v1.StaticAuthTokenProvider;
import io.confluent.function.sdk.v1.types.CfltFunctionArtifact;
import io.confluent.function.sdk.v1.types.CfltFunctionExecutionEnv;
import io.confluent.function.sdk.v1.types.CfltFunctionPoolExecutionEnv;
import io.confluent.function.sdk.v1.types.CfltFunctionPoolSpec;
import io.confluent.function.sdk.v1.types.CfltFunctionRuntime;
import io.confluent.function.sdk.v1.types.CfltFunctionSharedExecutionEnv;
import io.confluent.function.sdk.v1.types.CfltFunctionSpec;
import io.confluent.function.sdk.v1.types.ObjectMetadata;
import java.io.IOException;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CfltFunctionSharedRuntimeExample {
    private static final String controlPlaneGatewayMagicalAccessToken = System.getenv("CONTROL_PLANE_GATEWAY_MAGICAL_ACCESS_TOKEN");

    public static void main(String[] args) throws IOException, InterruptedException {
        CfltFunctionSharedRuntimeExample.enableVerboseSdkLogging();
        ObjectMetadata poolMetadata = ObjectMetadata.builder().name("user-func-pool-12345").org("e9eb4f2c-ef73-475c-ba7f-6b37a4ff00e5").environment("env-devc33qr20").build();
        CfltFunctionPoolSpec poolSpec = CfltFunctionPoolSpec.builder().executionEnv(CfltFunctionPoolExecutionEnv.builder().runtime(CfltFunctionRuntime.builder().type("jvm").version("jdk17").build()).build()).build();
        ObjectMetadata funcMetadata = ObjectMetadata.builder().name("user-func-12345").org("e9eb4f2c-ef73-475c-ba7f-6b37a4ff00e5").environment("env-devc33qr20").build();
        CfltFunctionSpec funcSpec = CfltFunctionSpec.builder().executionEnv(CfltFunctionExecutionEnv.builder().type("shared").shared(CfltFunctionSharedExecutionEnv.builder().poolName(poolMetadata.getName()).build()).build()).handler("io.confluent.udf.examples.HelloHandler").artifacts(List.of(CfltFunctionArtifact.builder().name("myhandler").scope("internal").pluginId("ccp-dev2tero8").versionId("ver-devc10zp6").inClassPath(true).build())).build();
        try (CfltFunctionManagementClient mgmtClient = new CfltFunctionManagementClientBuilder().withClientId("connect-custom-smt").useRegionalApiServer().withRegion(CloudRegion.AWS_US_WEST_2).withCCloudEnv(CCloudEnv.DEVEL).withAuthTokenProvider(new StaticAuthTokenProvider(controlPlaneGatewayMagicalAccessToken)).useExperimentalDevelPublicGateway().build();){
            mgmtClient.deleteCfltFunction(funcMetadata);
            mgmtClient.deleteCfltFunctionPool(poolMetadata);
            mgmtClient.createCfltFunctionPool(poolMetadata, poolSpec);
            mgmtClient.getCfltFunctionPool(poolMetadata);
            mgmtClient.createCfltFunction(funcMetadata, funcSpec);
            mgmtClient.getCfltFunction(funcMetadata);
        }
    }

    private static void enableVerboseSdkLogging() {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(Level.ALL);
        }
        Logger.getLogger("io.confluent.function.sdk.v1").setLevel(Level.ALL);
    }
}

