/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.version.metrics;

import io.confluent.ksql.version.metrics.KsqlVersionCheckerResponseHandler;
import io.confluent.ksql.version.metrics.collector.BasicCollector;
import io.confluent.ksql.version.metrics.collector.KsqlModuleType;
import io.confluent.support.metrics.BaseMetricsReporter;
import io.confluent.support.metrics.BaseSupportConfig;
import io.confluent.support.metrics.common.Collector;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class KsqlVersionChecker
extends BaseMetricsReporter {
    private final Collector metricsCollector;
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public KsqlVersionChecker(BaseSupportConfig ksqlVersionCheckerConfig, KsqlModuleType moduleType, boolean enableSettlingTime, Supplier<Boolean> activenessStatusSupplier) {
        super("KsqlVersionCheckerAgent", true, ksqlVersionCheckerConfig, new KsqlVersionCheckerResponseHandler(), enableSettlingTime);
        Runtime serverRuntime = Runtime.getRuntime();
        Objects.requireNonNull(serverRuntime, "serverRuntime is required");
        serverRuntime.addShutdownHook(new Thread(() -> this.shuttingDown.set(true)));
        this.metricsCollector = new BasicCollector(moduleType, activenessStatusSupplier);
    }

    @Override
    protected Collector metricsCollector() {
        return this.metricsCollector;
    }

    @Override
    protected boolean isReadyForMetricsCollection() {
        return true;
    }

    @Override
    protected boolean isShuttingDown() {
        return this.shuttingDown.get();
    }
}

