/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.version.metrics;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class KsqlVersionMetrics
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 441145512006693662L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"KsqlVersionMetrics\",\"namespace\":\"io.confluent.ksql.version.metrics\",\"doc\":\"Represents basic metrics captured on a single ksql component\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"Time when this data record was created on the ksql component (Unix time).\"},{\"name\":\"confluentPlatformVersion\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The version of the Confluent Platform this ksql component is running.\"},{\"name\":\"ksqlComponentType\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Identifies the ksql component\"},{\"name\":\"isActive\",\"type\":\"boolean\",\"doc\":\"Indicates if the server was active in the last 24 hours. A server is considered active if it received a rest request or it has at least one running query.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<KsqlVersionMetrics> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<KsqlVersionMetrics> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private long timestamp;
    private String confluentPlatformVersion;
    private String ksqlComponentType;
    private boolean isActive;
    private static final DatumWriter<KsqlVersionMetrics> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<KsqlVersionMetrics> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<KsqlVersionMetrics> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<KsqlVersionMetrics> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<KsqlVersionMetrics> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static KsqlVersionMetrics fromByteBuffer(ByteBuffer b) throws IOException {
        return (KsqlVersionMetrics)((Object)DECODER.decode(b));
    }

    public KsqlVersionMetrics() {
    }

    public KsqlVersionMetrics(Long timestamp, String confluentPlatformVersion, String ksqlComponentType, Boolean isActive) {
        this.timestamp = timestamp;
        this.confluentPlatformVersion = confluentPlatformVersion;
        this.ksqlComponentType = ksqlComponentType;
        this.isActive = isActive;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.timestamp;
            }
            case 1: {
                return this.confluentPlatformVersion;
            }
            case 2: {
                return this.ksqlComponentType;
            }
            case 3: {
                return this.isActive;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.timestamp = (Long)value$;
                break;
            }
            case 1: {
                this.confluentPlatformVersion = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.ksqlComponentType = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.isActive = (Boolean)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long value) {
        this.timestamp = value;
    }

    public String getConfluentPlatformVersion() {
        return this.confluentPlatformVersion;
    }

    public void setConfluentPlatformVersion(String value) {
        this.confluentPlatformVersion = value;
    }

    public String getKsqlComponentType() {
        return this.ksqlComponentType;
    }

    public void setKsqlComponentType(String value) {
        this.ksqlComponentType = value;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean value) {
        this.isActive = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(KsqlVersionMetrics other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeLong(this.timestamp);
        if (this.confluentPlatformVersion == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.confluentPlatformVersion);
        }
        out.writeString(this.ksqlComponentType);
        out.writeBoolean(this.isActive);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.timestamp = in.readLong();
            if (in.readIndex() != 1) {
                in.readNull();
                this.confluentPlatformVersion = null;
            } else {
                this.confluentPlatformVersion = in.readString();
            }
            this.ksqlComponentType = in.readString();
            this.isActive = in.readBoolean();
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.timestamp = in.readLong();
                        continue block6;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.confluentPlatformVersion = null;
                            continue block6;
                        }
                        this.confluentPlatformVersion = in.readString();
                        continue block6;
                    }
                    case 2: {
                        this.ksqlComponentType = in.readString();
                        continue block6;
                    }
                    case 3: {
                        this.isActive = in.readBoolean();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<KsqlVersionMetrics>
    implements RecordBuilder<KsqlVersionMetrics> {
        private long timestamp;
        private String confluentPlatformVersion;
        private String ksqlComponentType;
        private boolean isActive;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.timestamp)) {
                this.timestamp = (Long)this.data().deepCopy(this.fields()[0].schema(), (Object)other.timestamp);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.confluentPlatformVersion)) {
                this.confluentPlatformVersion = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.confluentPlatformVersion);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.ksqlComponentType)) {
                this.ksqlComponentType = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.ksqlComponentType);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.isActive)) {
                this.isActive = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.isActive);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(KsqlVersionMetrics other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.timestamp)) {
                this.timestamp = (Long)this.data().deepCopy(this.fields()[0].schema(), (Object)other.timestamp);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.confluentPlatformVersion)) {
                this.confluentPlatformVersion = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.confluentPlatformVersion);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.ksqlComponentType)) {
                this.ksqlComponentType = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.ksqlComponentType);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.isActive)) {
                this.isActive = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.isActive);
                this.fieldSetFlags()[3] = true;
            }
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Builder setTimestamp(long value) {
            this.validate(this.fields()[0], value);
            this.timestamp = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTimestamp() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTimestamp() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getConfluentPlatformVersion() {
            return this.confluentPlatformVersion;
        }

        public Builder setConfluentPlatformVersion(String value) {
            this.validate(this.fields()[1], value);
            this.confluentPlatformVersion = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasConfluentPlatformVersion() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearConfluentPlatformVersion() {
            this.confluentPlatformVersion = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getKsqlComponentType() {
            return this.ksqlComponentType;
        }

        public Builder setKsqlComponentType(String value) {
            this.validate(this.fields()[2], value);
            this.ksqlComponentType = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasKsqlComponentType() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearKsqlComponentType() {
            this.ksqlComponentType = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public boolean getIsActive() {
            return this.isActive;
        }

        public Builder setIsActive(boolean value) {
            this.validate(this.fields()[3], value);
            this.isActive = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasIsActive() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearIsActive() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public KsqlVersionMetrics build() {
            try {
                KsqlVersionMetrics record = new KsqlVersionMetrics();
                record.timestamp = this.fieldSetFlags()[0] ? this.timestamp : (Long)this.defaultValue(this.fields()[0]);
                record.confluentPlatformVersion = this.fieldSetFlags()[1] ? this.confluentPlatformVersion : (String)this.defaultValue(this.fields()[1]);
                record.ksqlComponentType = this.fieldSetFlags()[2] ? this.ksqlComponentType : (String)this.defaultValue(this.fields()[2]);
                record.isActive = this.fieldSetFlags()[3] ? this.isActive : (Boolean)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

