/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.common;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Filter {
    private final Set<String> keysToRemove;

    public Filter() {
        this(new HashSet<String>());
    }

    public Filter(Set<String> keysToRemove) {
        this.keysToRemove = new HashSet<String>(keysToRemove);
    }

    public Properties apply(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        if (properties.isEmpty()) {
            return new Properties();
        }
        Properties filtered = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (this.keysToRemove.contains(key)) continue;
            filtered.put(key, value);
        }
        return filtered;
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.keysToRemove);
    }
}

