/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.hcvault;

import com.google.common.collect.ImmutableMap;
import com.google.crypto.tink.Aead;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.response.LogicalResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Map;

public class HcVaultKmsAead
implements Aead {
    private final Logical vault;
    private final String encryptPath;
    private final String decryptPath;

    public HcVaultKmsAead(Logical vault, String keyUri) throws GeneralSecurityException {
        this.vault = vault;
        this.encryptPath = this.getOperationPath(keyUri, "encrypt");
        this.decryptPath = this.getOperationPath(keyUri, "decrypt");
    }

    private String getOperationPath(String keyUri, String op) throws GeneralSecurityException {
        try {
            URI uri = new URI(keyUri);
            String key = uri.getPath().substring(1);
            CharSequence[] parts = key.split("/");
            parts[1] = op;
            return String.join((CharSequence)"/", parts);
        }
        catch (URISyntaxException e) {
            throw new GeneralSecurityException("could not process uri " + keyUri, e);
        }
    }

    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        ImmutableMap request = ImmutableMap.of((Object)"plaintext", (Object)Base64.getEncoder().encodeToString(plaintext), (Object)"context", (Object)(associatedData == null ? "" : Base64.getEncoder().encodeToString(associatedData)));
        try {
            LogicalResponse response = this.vault.write(this.encryptPath, (Map)request);
            Map data = response.getData();
            String error = (String)data.get("errors");
            if (error != null) {
                throw new GeneralSecurityException("failed to encrypt");
            }
            String ciphertext = (String)data.get("ciphertext");
            if (ciphertext == null) {
                String err = new String(response.getRestResponse().getBody(), StandardCharsets.UTF_8);
                throw new GeneralSecurityException("encryption failed: " + err);
            }
            return ciphertext.getBytes(StandardCharsets.UTF_8);
        }
        catch (VaultException e) {
            throw new GeneralSecurityException("encryption failed", e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        ImmutableMap request = ImmutableMap.of((Object)"ciphertext", (Object)new String(ciphertext, StandardCharsets.UTF_8), (Object)"context", (Object)(associatedData == null ? "" : Base64.getEncoder().encodeToString(associatedData)));
        try {
            LogicalResponse response = this.vault.write(this.decryptPath, (Map)request);
            Map data = response.getData();
            String error = (String)data.get("errors");
            if (error != null) {
                throw new GeneralSecurityException("failed to decrypt");
            }
            String plaintext64 = (String)response.getData().get("plaintext");
            if (plaintext64 == null) {
                throw new GeneralSecurityException("decryption failed");
            }
            return Base64.getDecoder().decode(plaintext64);
        }
        catch (VaultException e) {
            throw new GeneralSecurityException("decryption failed", e);
        }
    }
}

