/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.hcvault;

import com.google.crypto.tink.KmsClient;
import io.confluent.kafka.schemaregistry.encryption.hcvault.HcVaultKmsClient;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriver;
import io.github.jopenlibs.vault.SslConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Logical;
import java.io.File;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Optional;

public class HcVaultKmsDriver
implements KmsDriver {
    public static final String TOKEN_ID = "token.id";
    public static final String NAMESPACE = "namespace";
    public static final String SSL_KEYSTORE_LOCATION = "ssl.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
    public static final String SSL_TRUSTSTORE_LOCATION = "ssl.truststore.location";
    public static final String VAULT_NAMESPACE = "VAULT_NAMESPACE";
    public static final String VAULT_SSL_KEYSTORE_LOCATION = "VAULT_SSL_KEYSTORE_LOCATION";
    public static final String VAULT_SSL_KEYSTORE_PASSWORD = "VAULT_SSL_KEYSTORE_PASSWORD";
    public static final String VAULT_SSL_TRUSTSTORE_LOCATION = "VAULT_SSL_TRUSTSTORE_LOCATION";

    public String getKeyUrlPrefix() {
        return "hcvault://";
    }

    private SslConfig getSslConfig(Map<String, ?> configs) throws GeneralSecurityException {
        String keystore = (String)configs.get(SSL_KEYSTORE_LOCATION);
        String keystorePassword = (String)configs.get(SSL_KEYSTORE_PASSWORD);
        String truststore = (String)configs.get(SSL_TRUSTSTORE_LOCATION);
        return HcVaultKmsDriver.getSslConfig(keystore, keystorePassword, truststore);
    }

    protected static SslConfig getSslConfig(String keystore, String keystorePassword, String truststore) throws GeneralSecurityException {
        try {
            boolean hasTrustStore;
            boolean hasKeyStore = keystore != null && !keystore.isEmpty();
            boolean bl = hasTrustStore = truststore != null && !truststore.isEmpty();
            if (hasKeyStore || hasTrustStore) {
                SslConfig sslConfig = new SslConfig();
                if (hasKeyStore) {
                    sslConfig = sslConfig.keyStoreFile(new File(keystore), keystorePassword);
                }
                if (hasTrustStore) {
                    sslConfig = sslConfig.trustStoreFile(new File(truststore));
                }
                return sslConfig.build();
            }
            return null;
        }
        catch (VaultException e) {
            throw new GeneralSecurityException("unable to create ssl config", e);
        }
    }

    private String getToken(Map<String, ?> configs) {
        return (String)configs.get(TOKEN_ID);
    }

    private String getNamespace(Map<String, ?> configs) {
        return (String)configs.get(NAMESPACE);
    }

    public KmsClient newKmsClient(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        Logical testClient = (Logical)this.getTestClient(configs);
        Optional<String> creds = testClient != null ? Optional.empty() : Optional.ofNullable(this.getToken(configs));
        SslConfig sslConfig = this.getSslConfig(configs);
        Optional<String> namespace = Optional.ofNullable(this.getNamespace(configs));
        return HcVaultKmsDriver.newKmsClientWithHcVaultKms(kekUrl, sslConfig, creds, namespace, testClient);
    }

    protected static KmsClient newKmsClientWithHcVaultKms(Optional<String> keyUri, SslConfig sslConfig, Optional<String> credentials, Optional<String> namespace, Logical vault) throws GeneralSecurityException {
        HcVaultKmsClient client = keyUri.isPresent() ? new HcVaultKmsClient(keyUri.get()) : new HcVaultKmsClient();
        if (credentials.isPresent()) {
            client.withCredentials(sslConfig, credentials.get(), namespace);
        } else {
            client.withDefaultCredentials();
        }
        if (vault != null) {
            client.withVault(vault);
        }
        return client;
    }
}

