/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.grapher.RootKeySetCreator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class DefaultRootKeySetCreator
implements RootKeySetCreator {
    private static final Key<Logger> loggerKey = Key.get(Logger.class);

    @Override
    public Set<Key<?>> getRootKeys(Injector injector) {
        HashSet root = Sets.newHashSet();
        for (Key key : injector.getBindings().keySet()) {
            if (key.getTypeLiteral().getRawType().getPackage() == Guice.class.getPackage() || loggerKey.equals((Object)key)) continue;
            root.add(key);
        }
        return root;
    }
}

