/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.common.base.Objects;
import com.google.inject.grapher.Node;
import com.google.inject.grapher.NodeId;
import java.lang.reflect.Member;

public class InstanceNode
extends Node {
    private final Object instance;
    private final Iterable<Member> members;

    public InstanceNode(NodeId id, Object source, Object instance, Iterable<Member> members) {
        super(id, source);
        this.instance = instance;
        this.members = members;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Iterable<Member> getMembers() {
        return this.members;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof InstanceNode)) {
            return false;
        }
        InstanceNode other = (InstanceNode)obj;
        return super.equals(other) && Objects.equal((Object)this.instance, (Object)other.instance) && Objects.equal(this.members, other.members);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object[])new Object[]{this.instance, this.members});
    }

    public String toString() {
        return "InstanceNode{id=" + this.getId() + " source=" + this.getSource() + " instance=" + this.instance + " members=" + this.members + "}";
    }

    @Override
    public Node copy(NodeId id) {
        return new InstanceNode(id, this.getSource(), this.getInstance(), this.getMembers());
    }
}

