/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher.graphviz;

import com.google.common.collect.ImmutableList;
import com.google.inject.grapher.NodeId;
import com.google.inject.grapher.graphviz.ArrowType;
import com.google.inject.grapher.graphviz.CompassPoint;
import com.google.inject.grapher.graphviz.EdgeStyle;
import java.util.List;

public class GraphvizEdge {
    private final NodeId headNodeId;
    private String headPortId;
    private CompassPoint headCompassPoint;
    private List<ArrowType> arrowHead = ImmutableList.of((Object)((Object)ArrowType.NORMAL));
    private final NodeId tailNodeId;
    private String tailPortId;
    private CompassPoint tailCompassPoint;
    private List<ArrowType> arrowTail = ImmutableList.of((Object)((Object)ArrowType.NONE));
    private EdgeStyle style = EdgeStyle.SOLID;

    public GraphvizEdge(NodeId tailNodeId, NodeId headNodeId) {
        this.tailNodeId = tailNodeId;
        this.headNodeId = headNodeId;
    }

    public NodeId getHeadNodeId() {
        return this.headNodeId;
    }

    public String getHeadPortId() {
        return this.headPortId;
    }

    public void setHeadPortId(String headPortId) {
        this.headPortId = headPortId;
    }

    public CompassPoint getHeadCompassPoint() {
        return this.headCompassPoint;
    }

    public void setHeadCompassPoint(CompassPoint headCompassPoint) {
        this.headCompassPoint = headCompassPoint;
    }

    public List<ArrowType> getArrowHead() {
        return this.arrowHead;
    }

    public void setArrowHead(List<ArrowType> arrowHead) {
        this.arrowHead = ImmutableList.copyOf(arrowHead);
    }

    public NodeId getTailNodeId() {
        return this.tailNodeId;
    }

    public String getTailPortId() {
        return this.tailPortId;
    }

    public void setTailPortId(String tailPortId) {
        this.tailPortId = tailPortId;
    }

    public CompassPoint getTailCompassPoint() {
        return this.tailCompassPoint;
    }

    public void setTailCompassPoint(CompassPoint tailCompassPoint) {
        this.tailCompassPoint = tailCompassPoint;
    }

    public List<ArrowType> getArrowTail() {
        return this.arrowTail;
    }

    public void setArrowTail(List<ArrowType> arrowTail) {
        this.arrowTail = ImmutableList.copyOf(arrowTail);
    }

    public EdgeStyle getStyle() {
        return this.style;
    }

    public void setStyle(EdgeStyle style) {
        this.style = style;
    }
}

