/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.auth.plain;

import io.confluent.kafka.security.auth.plain.DynamicPlainClientCallbackHandler;
import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.RealmCallback;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.JaasContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynamicPlainClientCallbackHandlerTest {
    private final Subject subject = new Subject();
    private final DynamicPlainClientCallbackHandler callbackHandler = new DynamicPlainClientCallbackHandler();
    private final NameCallback nameCallback = new NameCallback("name");
    private final PasswordCallback passwordCallback = new PasswordCallback("password", false);
    private JaasContext jaasContext;

    @BeforeEach
    public void setup() {
        String jaasConfig = "io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule required username_config=\"test.username\" password_config=\"test.password\";";
        this.jaasContext = JaasContext.loadClientContext(Collections.singletonMap("sasl.jaas.config", new Password(jaasConfig)));
    }

    @Test
    public void testCallbackHandler() throws Exception {
        DynamicPlainCredential credential = new DynamicPlainCredential("alice", "alice-password".toCharArray());
        this.subject.getPrivateCredentials().add(credential);
        this.invokeCallbackHandler();
        Assertions.assertEquals((Object)"alice", (Object)this.nameCallback.getName());
        Assertions.assertEquals((Object)"alice-password", (Object)new String(this.passwordCallback.getPassword()));
        DynamicPlainCredential newCredential = new DynamicPlainCredential("bob", "bob-password".toCharArray());
        this.subject.getPrivateCredentials().add(newCredential);
        this.invokeCallbackHandler();
        DynamicPlainCredential callbackCredential = new DynamicPlainCredential(this.nameCallback.getName(), this.passwordCallback.getPassword());
        Assertions.assertTrue((boolean)Set.of(credential, newCredential).contains(callbackCredential));
    }

    @Test
    public void testNoPassword() {
        Assertions.assertThrows(UnsupportedCallbackException.class, () -> this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback}));
    }

    @Test
    public void testUnsupportedCallback() {
        Assertions.assertThrows(UnsupportedCallbackException.class, () -> this.callbackHandler.handle(new Callback[]{new RealmCallback("realm")}));
    }

    @Test
    public void testConfigure() {
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.configure(Collections.emptyMap(), "GSSAPI", this.jaasContext.configurationEntries()));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.configure(Collections.emptyMap(), "PLAIN", Collections.emptyList()));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.configure(Collections.emptyMap(), "PLAIN", Arrays.asList((AppConfigurationEntry)this.jaasContext.configurationEntries().get(0), (AppConfigurationEntry)this.jaasContext.configurationEntries().get(0))));
        this.callbackHandler.configure(Collections.emptyMap(), "PLAIN", this.jaasContext.configurationEntries());
    }

    private void invokeCallbackHandler() throws Exception {
        Subject.doAs(this.subject, () -> {
            this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback});
            return null;
        });
    }
}

