/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.clients.consumer.ShareConsumerConfig;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ShareAcknowledgeRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeResponse;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.requests.ShareGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class KafkaShareConsumerTest {
    private final String groupId = "test-group";
    private final String clientId1 = "client-id-1";
    private final String topic1 = "test1";
    private final Uuid topicId1 = Uuid.randomUuid();
    private final TopicPartition t1p0 = new TopicPartition("test1", 0);
    private final TopicIdPartition ti1p0 = new TopicIdPartition(this.topicId1, this.t1p0);
    private final Map<String, Uuid> topicIds = Map.of("test1", this.topicId1);
    private final int batchSize = 10;
    private final int heartbeatIntervalMs = 1000;
    private final Time time = new MockTime();
    private final SubscriptionState subscription = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.EARLIEST);

    @Test
    public void testVerifyHeartbeats() throws InterruptedException {
        ConsumerMetadata metadata = new ConsumerMetadata(0L, 0L, Long.MAX_VALUE, false, false, this.subscription, new LogContext(), new ClusterResourceListeners());
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Map.of("test1", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        Node coordinator = this.findCoordinator(client, node);
        AtomicReference memberId = new AtomicReference();
        AtomicInteger heartbeatsReceived = new AtomicInteger();
        client.prepareResponseFrom(body -> {
            if (body instanceof ShareGroupHeartbeatRequest) {
                ShareGroupHeartbeatRequest request = (ShareGroupHeartbeatRequest)body;
                memberId.set(Uuid.fromString((String)request.data().memberId()));
                boolean matches = request.data().memberEpoch() == 0;
                heartbeatsReceived.addAndGet(1);
                client.prepareResponseFrom(body2 -> {
                    if (body2 instanceof ShareGroupHeartbeatRequest) {
                        ShareGroupHeartbeatRequest request2 = (ShareGroupHeartbeatRequest)body2;
                        boolean matches2 = request2.data().memberId().equals(((Uuid)memberId.get()).toString()) && request2.data().memberEpoch() == 1;
                        heartbeatsReceived.addAndGet(1);
                        return matches2;
                    }
                    return false;
                }, (AbstractResponse)this.shareGroupHeartbeatResponse((Uuid)memberId.get(), 2, this.ti1p0), coordinator);
                return matches;
            }
            return false;
        }, (AbstractResponse)this.shareGroupHeartbeatResponse((Uuid)memberId.get(), 1, this.ti1p0), coordinator);
        try (KafkaShareConsumer<String, String> consumer = this.newShareConsumer("client-id-1", metadata, client);){
            consumer.subscribe(Set.of("test1"));
            consumer.poll(Duration.ZERO);
            Thread.sleep(1000L);
            Assertions.assertEquals((int)2, (int)heartbeatsReceived.get());
            Assertions.assertTrue((boolean)client.futureResponses().isEmpty());
            consumer.close(Duration.ZERO);
        }
    }

    @Disabled
    @Test
    public void testVerifyFetchAndCommitSyncImplicit() {
        ConsumerMetadata metadata = new ConsumerMetadata(0L, 0L, Long.MAX_VALUE, false, false, this.subscription, new LogContext(), new ClusterResourceListeners());
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Map.of("test1", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        Node coordinator = this.findCoordinator(client, node);
        AtomicReference<Uuid> memberId = new AtomicReference<Uuid>();
        AtomicBoolean memberLeft = this.shareGroupHeartbeatGenerator(client, coordinator, memberId, this.ti1p0);
        client.prepareResponseFrom(body -> {
            if (body instanceof ShareFetchRequest) {
                ShareFetchRequest request = (ShareFetchRequest)body;
                return request.data().groupId().equals("test-group") && request.data().shareSessionEpoch() == 0 && request.data().batchSize() == 10 && ((ShareFetchRequestData.FetchTopic)request.data().topics().stream().findFirst().get()).topicId().equals((Object)this.topicId1) && ((ShareFetchRequestData.FetchTopic)request.data().topics().stream().findFirst().get()).partitions().size() == 1 && ((ShareFetchRequestData.FetchPartition)((ShareFetchRequestData.FetchTopic)request.data().topics().stream().findFirst().get()).partitions().stream().findFirst().get()).acknowledgementBatches().isEmpty();
            }
            return false;
        }, (AbstractResponse)this.shareFetchResponse(this.ti1p0, 2), node);
        client.prepareResponseFrom(body -> {
            if (body instanceof ShareAcknowledgeRequest) {
                ShareAcknowledgeRequest request = (ShareAcknowledgeRequest)body;
                return request.data().groupId().equals("test-group") && request.data().shareSessionEpoch() == 1 && ((ShareAcknowledgeRequestData.AcknowledgementBatch)((ShareAcknowledgeRequestData.AcknowledgePartition)((ShareAcknowledgeRequestData.AcknowledgeTopic)request.data().topics().stream().findFirst().get()).partitions().stream().findFirst().get()).acknowledgementBatches().get(0)).firstOffset() == 0L && ((ShareAcknowledgeRequestData.AcknowledgementBatch)((ShareAcknowledgeRequestData.AcknowledgePartition)((ShareAcknowledgeRequestData.AcknowledgeTopic)request.data().topics().stream().findFirst().get()).partitions().stream().findFirst().get()).acknowledgementBatches().get(0)).lastOffset() == 1L && ((ShareAcknowledgeRequestData.AcknowledgementBatch)((ShareAcknowledgeRequestData.AcknowledgePartition)((ShareAcknowledgeRequestData.AcknowledgeTopic)request.data().topics().stream().findFirst().get()).partitions().stream().findFirst().get()).acknowledgementBatches().get(0)).acknowledgeTypes().size() == 1 && (Byte)((ShareAcknowledgeRequestData.AcknowledgementBatch)((ShareAcknowledgeRequestData.AcknowledgePartition)((ShareAcknowledgeRequestData.AcknowledgeTopic)request.data().topics().stream().findFirst().get()).partitions().stream().findFirst().get()).acknowledgementBatches().get(0)).acknowledgeTypes().get(0) == 1;
            }
            return false;
        }, (AbstractResponse)this.shareAcknowledgeResponse(this.ti1p0), node);
        client.prepareResponseFrom(body -> {
            if (body instanceof ShareAcknowledgeRequest) {
                ShareAcknowledgeRequest request = (ShareAcknowledgeRequest)body;
                return request.data().groupId().equals("test-group") && request.data().shareSessionEpoch() == -1 && request.data().topics().isEmpty();
            }
            return false;
        }, (AbstractResponse)this.shareAcknowledgeResponse(), node);
        try (KafkaShareConsumer<String, String> consumer = this.newShareConsumer("client-id-1", metadata, client);){
            consumer.subscribe(Set.of("test1"));
            consumer.poll(Duration.ofMillis(5000L));
            consumer.commitSync();
            consumer.close(Duration.ZERO);
            Assertions.assertTrue((boolean)memberLeft.get());
            Assertions.assertTrue((boolean)client.futureResponses().isEmpty());
        }
    }

    @Disabled
    @Test
    public void testVerifyFetchAndCloseImplicit() {
        ConsumerMetadata metadata = new ConsumerMetadata(0L, 0L, Long.MAX_VALUE, false, false, this.subscription, new LogContext(), new ClusterResourceListeners());
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Map.of("test1", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        Node coordinator = this.findCoordinator(client, node);
        AtomicReference<Uuid> memberId = new AtomicReference<Uuid>();
        AtomicBoolean memberLeft = this.shareGroupHeartbeatGenerator(client, coordinator, memberId, this.ti1p0);
        client.prepareResponseFrom(body -> {
            if (body instanceof ShareFetchRequest) {
                ShareFetchRequest request = (ShareFetchRequest)body;
                return request.data().groupId().equals("test-group") && request.data().shareSessionEpoch() == 0 && request.data().batchSize() == 10 && ((ShareFetchRequestData.FetchTopic)request.data().topics().stream().findFirst().get()).topicId().equals((Object)this.topicId1) && ((ShareFetchRequestData.FetchTopic)request.data().topics().stream().findFirst().get()).partitions().size() == 1 && ((ShareFetchRequestData.FetchPartition)((ShareFetchRequestData.FetchTopic)request.data().topics().stream().findFirst().get()).partitions().stream().findFirst().get()).acknowledgementBatches().isEmpty();
            }
            return false;
        }, (AbstractResponse)this.shareFetchResponse(this.ti1p0, 2), node);
        client.prepareResponseFrom(body -> {
            if (body instanceof ShareAcknowledgeRequest) {
                ShareAcknowledgeRequest request = (ShareAcknowledgeRequest)body;
                return request.data().groupId().equals("test-group") && request.data().shareSessionEpoch() == -1 && request.data().topics().isEmpty();
            }
            return false;
        }, (AbstractResponse)this.shareAcknowledgeResponse(), node);
        try (KafkaShareConsumer<String, String> consumer = this.newShareConsumer("client-id-1", metadata, client);){
            consumer.subscribe(Set.of("test1"));
            consumer.poll(Duration.ofMillis(5000L));
            consumer.close(Duration.ZERO);
            Assertions.assertTrue((boolean)memberLeft.get());
            Assertions.assertTrue((boolean)client.futureResponses().isEmpty());
        }
    }

    private KafkaShareConsumer<String, String> newShareConsumer(String clientId, ConsumerMetadata metadata, KafkaClient client) {
        LogContext logContext = new LogContext();
        StringDeserializer keyDeserializer = new StringDeserializer();
        StringDeserializer valueDeserializer = new StringDeserializer();
        ShareConsumerConfig config = this.newConsumerConfig(clientId);
        return new KafkaShareConsumer(logContext, clientId, "test-group", config, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, this.time, client, this.subscription, metadata);
    }

    private ShareConsumerConfig newConsumerConfig(String clientId) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("client.id", clientId);
        configs.put("group.id", "test-group");
        configs.put("key.deserializer", StringDeserializer.class);
        configs.put("value.deserializer", StringDeserializer.class);
        configs.put("max.poll.records", 10);
        return new ShareConsumerConfig(configs);
    }

    private void initMetadata(MockClient client, Map<String, Integer> partitions) {
        HashMap<String, Uuid> metadataTopicIds = new HashMap<String, Uuid>();
        for (String name : partitions.keySet()) {
            metadataTopicIds.put(name, this.topicIds.get(name));
        }
        MetadataResponse initialMetadata = RequestTestUtils.metadataUpdateWithIds(1, partitions, metadataTopicIds);
        client.updateMetadata(initialMetadata);
    }

    private Node findCoordinator(MockClient client, Node node) {
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"test-group", (Node)node), node);
        return new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
    }

    private AtomicBoolean shareGroupHeartbeatGenerator(MockClient client, Node coordinator, AtomicReference<Uuid> memberId, TopicIdPartition tip) {
        AtomicBoolean memberLeft = new AtomicBoolean();
        AtomicInteger heartbeatsReceived = new AtomicInteger();
        this.shareGroupHeartbeat(client, coordinator, memberId, 0, tip, heartbeatsReceived, memberLeft);
        return memberLeft;
    }

    private void shareGroupHeartbeat(MockClient client, Node coordinator, AtomicReference<Uuid> memberId, int memberEpoch, TopicIdPartition tip, AtomicInteger heartbeatsReceived, AtomicBoolean memberLeft) {
        client.prepareResponseFrom(body -> {
            if (body instanceof ShareGroupHeartbeatRequest) {
                ShareGroupHeartbeatRequest request = (ShareGroupHeartbeatRequest)body;
                if (request.data().memberEpoch() == 0) {
                    memberId.set(Uuid.fromString((String)request.data().memberId()));
                }
                if (request.data().memberEpoch() == -1) {
                    memberLeft.set(true);
                } else {
                    this.shareGroupHeartbeat(client, coordinator, memberId, memberEpoch + 1, tip, heartbeatsReceived, memberLeft);
                }
                heartbeatsReceived.addAndGet(1);
                return true;
            }
            return false;
        }, (AbstractResponse)this.shareGroupHeartbeatResponse(memberId.get(), memberEpoch, tip), coordinator);
    }

    private ShareGroupHeartbeatResponse shareGroupHeartbeatResponse(Uuid memberId, int memberEpoch, TopicIdPartition tip) {
        if (memberEpoch != -1) {
            LinkedList<ShareGroupHeartbeatResponseData.TopicPartitions> assignedPartitions = new LinkedList<ShareGroupHeartbeatResponseData.TopicPartitions>();
            assignedPartitions.add(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(tip.topicId()).setPartitions(List.of(Integer.valueOf(tip.partition()))));
            return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setMemberId(memberId != null ? memberId.toString() : null).setMemberEpoch(memberEpoch).setHeartbeatIntervalMs(1000).setAssignment(new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(assignedPartitions)));
        }
        return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData().setMemberId(memberId != null ? memberId.toString() : null).setMemberEpoch(memberEpoch).setHeartbeatIntervalMs(1000));
    }

    private ShareFetchResponse shareFetchResponse(TopicIdPartition tip, int count) {
        MemoryRecords records;
        try (MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);){
            for (int i = 0; i < count; ++i) {
                builder.append(0L, ("key-" + i).getBytes(), ("value-" + i).getBytes());
            }
            records = builder.build();
        }
        ShareFetchResponseData.PartitionData partData = new ShareFetchResponseData.PartitionData().setPartitionIndex(tip.partition()).setRecords((BaseRecords)records).setAcquiredRecords(List.of(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(0L).setLastOffset((long)(count - 1)).setDeliveryCount((short)1)));
        return ShareFetchResponse.of((Errors)Errors.NONE, (int)0, new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>(Map.of(tip, partData)), List.of(), (int)0);
    }

    private ShareAcknowledgeResponse shareAcknowledgeResponse() {
        return new ShareAcknowledgeResponse(new ShareAcknowledgeResponseData());
    }

    private ShareAcknowledgeResponse shareAcknowledgeResponse(TopicIdPartition tip) {
        ShareAcknowledgeResponseData.PartitionData partData = new ShareAcknowledgeResponseData.PartitionData().setPartitionIndex(tip.partition()).setErrorCode(Errors.NONE.code());
        ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse topicResponse = new ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponse().setTopicId(tip.topicId()).setPartitions(List.of(partData));
        return new ShareAcknowledgeResponse(new ShareAcknowledgeResponseData().setResponses(new ShareAcknowledgeResponseData.ShareAcknowledgeTopicResponseCollection(List.of(topicResponse).iterator())));
    }
}

