/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.logging.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;

public class CoordinatorRequestManagerTest {
    private static final int RETRY_BACKOFF_MS = 500;
    private static final String GROUP_ID = "group-1";
    private MockTime time;
    private BackgroundEventHandler backgroundEventHandler;
    private Node node;

    @BeforeEach
    public void setup() {
        this.time = new MockTime(0L);
        this.node = new Node(1, "localhost", 9092);
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class);
    }

    @Test
    public void testSuccessfulResponse() {
        CoordinatorRequestManager coordinatorManager = this.setupCoordinatorManager(GROUP_ID);
        this.expectFindCoordinatorRequest(coordinatorManager, Errors.NONE);
        Optional coordinatorOpt = coordinatorManager.coordinator();
        Assertions.assertTrue((boolean)coordinatorOpt.isPresent());
        Assertions.assertEquals((int)(Integer.MAX_VALUE - this.node.id()), (int)((Node)coordinatorOpt.get()).id());
        Assertions.assertEquals((Object)this.node.host(), (Object)((Node)coordinatorOpt.get()).host());
        Assertions.assertEquals((int)this.node.port(), (int)((Node)coordinatorOpt.get()).port());
        NetworkClientDelegate.PollResult pollResult = coordinatorManager.poll(this.time.milliseconds());
        Assertions.assertEquals(Collections.emptyList(), (Object)pollResult.unsentRequests);
    }

    @Test
    public void testMarkCoordinatorUnknownLoggingAccuracy() {
        long oneMinute = 60000L;
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            appender.setClassLogger(CoordinatorRequestManager.class, Level.WARN);
            CoordinatorRequestManager coordinatorRequestManager = this.setupCoordinatorManager(GROUP_ID);
            Assertions.assertFalse((boolean)coordinatorRequestManager.coordinator().isPresent());
            coordinatorRequestManager.markCoordinatorUnknown("test", this.time.milliseconds());
            Assertions.assertTrue((boolean)this.millisecondsFromLog(appender).isEmpty());
            this.time.sleep(oneMinute);
            coordinatorRequestManager.markCoordinatorUnknown("test", this.time.milliseconds());
            Optional<Long> firstLogMs = this.millisecondsFromLog(appender);
            Assertions.assertTrue((boolean)firstLogMs.isPresent());
            Assertions.assertEquals((long)oneMinute, (Long)firstLogMs.get());
            this.time.sleep(oneMinute);
            coordinatorRequestManager.markCoordinatorUnknown("test", this.time.milliseconds());
            Optional<Long> secondLogMs = this.millisecondsFromLog(appender);
            Assertions.assertTrue((boolean)secondLogMs.isPresent());
            Assertions.assertEquals((long)(oneMinute * 2L), (Long)secondLogMs.get());
        }
    }

    private Optional<Long> millisecondsFromLog(LogCaptureAppender appender) {
        Pattern pattern = Pattern.compile("^Consumer has been disconnected from the group coordinator for (?<millis>\\d+)+ms$");
        List milliseconds = appender.getMessages().stream().map(pattern::matcher).filter(Matcher::find).map(matcher -> matcher.group("millis")).filter(Objects::nonNull).map(millisString -> {
            try {
                return Long.parseLong(millisString);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return milliseconds.isEmpty() ? Optional.empty() : Optional.of((Long)milliseconds.get(milliseconds.size() - 1));
    }

    @Test
    public void testMarkCoordinatorUnknown() {
        CoordinatorRequestManager coordinatorManager = this.setupCoordinatorManager(GROUP_ID);
        this.expectFindCoordinatorRequest(coordinatorManager, Errors.NONE);
        Assertions.assertTrue((boolean)coordinatorManager.coordinator().isPresent());
        coordinatorManager.markCoordinatorUnknown("coordinator changed", this.time.milliseconds());
        Assertions.assertEquals(Collections.emptyList(), (Object)coordinatorManager.poll((long)this.time.milliseconds()).unsentRequests);
        this.time.sleep(499L);
        Assertions.assertEquals(Collections.emptyList(), (Object)coordinatorManager.poll((long)this.time.milliseconds()).unsentRequests);
        this.time.sleep(500L);
        this.expectFindCoordinatorRequest(coordinatorManager, Errors.NONE);
        Assertions.assertTrue((boolean)coordinatorManager.coordinator().isPresent());
    }

    @Test
    public void testBackoffAfterRetriableFailure() {
        CoordinatorRequestManager coordinatorManager = this.setupCoordinatorManager(GROUP_ID);
        this.expectFindCoordinatorRequest(coordinatorManager, Errors.COORDINATOR_LOAD_IN_PROGRESS);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.backgroundEventHandler});
        this.time.sleep(499L);
        Assertions.assertEquals(Collections.emptyList(), (Object)coordinatorManager.poll((long)this.time.milliseconds()).unsentRequests);
        this.time.sleep(1L);
        this.expectFindCoordinatorRequest(coordinatorManager, Errors.NONE);
    }

    @Test
    public void testBackoffAfterFatalError() {
        CoordinatorRequestManager coordinatorManager = this.setupCoordinatorManager(GROUP_ID);
        this.expectFindCoordinatorRequest(coordinatorManager, Errors.GROUP_AUTHORIZATION_FAILED);
        this.time.sleep(499L);
        Assertions.assertEquals(Collections.emptyList(), (Object)coordinatorManager.poll((long)this.time.milliseconds()).unsentRequests);
        this.time.sleep(1L);
        Assertions.assertEquals((int)1, (int)coordinatorManager.poll((long)this.time.milliseconds()).unsentRequests.size());
        Assertions.assertEquals(Optional.empty(), (Object)coordinatorManager.coordinator());
    }

    @Test
    public void testNullGroupIdShouldThrow() {
        Assertions.assertThrows(RuntimeException.class, () -> this.setupCoordinatorManager(null));
    }

    @Test
    public void testFindCoordinatorResponseVersions() {
        FindCoordinatorResponse respNew = FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)GROUP_ID, (Node)this.node);
        Assertions.assertTrue((boolean)respNew.coordinatorByKey(GROUP_ID).isPresent());
        Assertions.assertEquals((Object)GROUP_ID, (Object)((FindCoordinatorResponseData.Coordinator)respNew.coordinatorByKey(GROUP_ID).get()).key());
        Assertions.assertEquals((int)this.node.id(), (int)((FindCoordinatorResponseData.Coordinator)respNew.coordinatorByKey(GROUP_ID).get()).nodeId());
        FindCoordinatorResponse respOld = FindCoordinatorResponse.prepareOldResponse((Errors)Errors.NONE, (Node)this.node);
        Assertions.assertTrue((boolean)respOld.coordinatorByKey(GROUP_ID).isPresent());
        Assertions.assertEquals((int)this.node.id(), (int)((FindCoordinatorResponseData.Coordinator)respNew.coordinatorByKey(GROUP_ID).get()).nodeId());
    }

    @Test
    public void testNetworkTimeout() {
        CoordinatorRequestManager coordinatorManager = this.setupCoordinatorManager(GROUP_ID);
        NetworkClientDelegate.PollResult res = coordinatorManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).handler().onFailure(this.time.milliseconds(), (RuntimeException)new TimeoutException());
        this.time.sleep(499L);
        NetworkClientDelegate.PollResult res2 = coordinatorManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)res2.unsentRequests.size());
        this.time.sleep(1L);
        res2 = coordinatorManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res2.unsentRequests.size());
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "COORDINATOR_NOT_AVAILABLE"})
    public void testClearFatalErrorWhenReceivingSuccessfulResponse(Errors error) {
        CoordinatorRequestManager coordinatorManager = this.setupCoordinatorManager(GROUP_ID);
        this.expectFindCoordinatorRequest(coordinatorManager, Errors.GROUP_AUTHORIZATION_FAILED);
        Assertions.assertTrue((boolean)coordinatorManager.fatalError().isPresent());
        this.time.sleep(500L);
        Assertions.assertTrue((boolean)coordinatorManager.fatalError().isPresent());
        this.expectFindCoordinatorRequest(coordinatorManager, error);
        Assertions.assertTrue((boolean)coordinatorManager.fatalError().isEmpty());
    }

    private void expectFindCoordinatorRequest(CoordinatorRequestManager coordinatorManager, Errors error) {
        NetworkClientDelegate.PollResult res = coordinatorManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        unsentRequest.handler().onComplete(this.buildResponse(unsentRequest, error));
        boolean expectCoordinatorFound = error == Errors.NONE;
        Assertions.assertEquals((Object)expectCoordinatorFound, (Object)coordinatorManager.coordinator().isPresent());
    }

    private CoordinatorRequestManager setupCoordinatorManager(String groupId) {
        return new CoordinatorRequestManager(new LogContext(), 500L, 500L, groupId);
    }

    private ClientResponse buildResponse(NetworkClientDelegate.UnsentRequest request, Errors error) {
        AbstractRequest abstractRequest = request.requestBuilder().build();
        Assertions.assertInstanceOf(FindCoordinatorRequest.class, (Object)abstractRequest);
        FindCoordinatorRequest findCoordinatorRequest = (FindCoordinatorRequest)abstractRequest;
        FindCoordinatorResponse findCoordinatorResponse = FindCoordinatorResponse.prepareResponse((Errors)error, (String)GROUP_ID, (Node)this.node);
        return new ClientResponse(new RequestHeader(ApiKeys.FIND_COORDINATOR, findCoordinatorRequest.version(), "", 1), (RequestCompletionHandler)request.handler(), this.node.idString(), this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)findCoordinatorResponse);
    }
}

