/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.ArrayList;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.events.CompletableEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableEventReaper;
import org.apache.kafka.clients.consumer.internals.events.UnsubscribeEvent;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompletableEventReaperTest {
    private final LogContext logContext = new LogContext();
    private final Time time = new MockTime();
    private final CompletableEventReaper reaper = new CompletableEventReaper(this.logContext);

    @Test
    public void testExpired() {
        long timeoutMs = 100L;
        UnsubscribeEvent event = new UnsubscribeEvent(CompletableEvent.calculateDeadlineMs((long)this.time.milliseconds(), (long)timeoutMs));
        this.reaper.add((CompletableEvent)event);
        Assertions.assertEquals((long)0L, (long)this.reaper.reap(this.time.milliseconds()));
        Assertions.assertFalse((boolean)event.future().isDone());
        Assertions.assertEquals((int)1, (int)this.reaper.size());
        this.time.sleep(timeoutMs + 1L);
        Assertions.assertFalse((boolean)event.future().isDone());
        Assertions.assertEquals((int)1, (int)this.reaper.size());
        Assertions.assertEquals((long)1L, (long)this.reaper.reap(this.time.milliseconds()));
        Assertions.assertTrue((boolean)event.future().isDone());
        Assertions.assertThrows(TimeoutException.class, () -> ConsumerUtils.getResult((Future)event.future()));
        Assertions.assertEquals((int)0, (int)this.reaper.size());
    }

    @Test
    public void testCompleted() {
        long timeoutMs = 100L;
        UnsubscribeEvent event = new UnsubscribeEvent(CompletableEvent.calculateDeadlineMs((long)this.time.milliseconds(), (long)timeoutMs));
        this.reaper.add((CompletableEvent)event);
        Assertions.assertEquals((long)0L, (long)this.reaper.reap(this.time.milliseconds()));
        Assertions.assertFalse((boolean)event.future().isDone());
        Assertions.assertEquals((int)1, (int)this.reaper.size());
        event.future().complete(null);
        Assertions.assertTrue((boolean)event.future().isDone());
        Assertions.assertEquals((int)1, (int)this.reaper.size());
        this.time.sleep(timeoutMs + 1L);
        Assertions.assertEquals((long)0L, (long)this.reaper.reap(this.time.milliseconds()));
        Assertions.assertTrue((boolean)event.future().isDone());
        Assertions.assertNull((Object)ConsumerUtils.getResult((Future)event.future()));
        Assertions.assertEquals((int)0, (int)this.reaper.size());
    }

    @Test
    public void testCompletedAndExpired() {
        long timeoutMs = 100L;
        UnsubscribeEvent event1 = new UnsubscribeEvent(CompletableEvent.calculateDeadlineMs((long)this.time.milliseconds(), (long)timeoutMs));
        UnsubscribeEvent event2 = new UnsubscribeEvent(CompletableEvent.calculateDeadlineMs((long)this.time.milliseconds(), (long)timeoutMs));
        this.reaper.add((CompletableEvent)event1);
        this.reaper.add((CompletableEvent)event2);
        Assertions.assertEquals((long)0L, (long)this.reaper.reap(this.time.milliseconds()));
        Assertions.assertFalse((boolean)event1.future().isDone());
        Assertions.assertFalse((boolean)event2.future().isDone());
        Assertions.assertEquals((int)2, (int)this.reaper.size());
        event1.future().complete(null);
        Assertions.assertTrue((boolean)event1.future().isDone());
        this.time.sleep(timeoutMs + 1L);
        Assertions.assertEquals((int)2, (int)this.reaper.size());
        Assertions.assertEquals((long)1L, (long)this.reaper.reap(this.time.milliseconds()));
        Assertions.assertTrue((boolean)event1.future().isDone());
        Assertions.assertTrue((boolean)event2.future().isDone());
        Assertions.assertNull((Object)ConsumerUtils.getResult((Future)event1.future()));
        Assertions.assertThrows(TimeoutException.class, () -> ConsumerUtils.getResult((Future)event2.future()));
        Assertions.assertEquals((int)0, (int)this.reaper.size());
    }

    @Test
    public void testIncompleteQueue() {
        long timeoutMs = 100L;
        UnsubscribeEvent event1 = new UnsubscribeEvent(CompletableEvent.calculateDeadlineMs((long)this.time.milliseconds(), (long)timeoutMs));
        UnsubscribeEvent event2 = new UnsubscribeEvent(CompletableEvent.calculateDeadlineMs((long)this.time.milliseconds(), (long)timeoutMs));
        ArrayList<UnsubscribeEvent> queue = new ArrayList<UnsubscribeEvent>();
        queue.add(event1);
        queue.add(event2);
        event1.future().complete(null);
        Assertions.assertEquals((int)0, (int)this.reaper.size());
        Assertions.assertEquals((int)2, (int)queue.size());
        Assertions.assertEquals((long)1L, (long)this.reaper.reap(queue));
        Assertions.assertTrue((boolean)event1.future().isDone());
        Assertions.assertFalse((boolean)event1.future().isCancelled());
        Assertions.assertNull((Object)ConsumerUtils.getResult((Future)event1.future()));
        Assertions.assertTrue((boolean)event2.future().isCompletedExceptionally());
        Assertions.assertThrows(TimeoutException.class, () -> ConsumerUtils.getResult((Future)event2.future()));
        Assertions.assertEquals((int)0, (int)this.reaper.size());
        Assertions.assertEquals((int)0, (int)queue.size());
    }

    @Test
    public void testIncompleteTracked() {
        ArrayList queue = new ArrayList();
        long timeoutMs = 100L;
        UnsubscribeEvent event1 = new UnsubscribeEvent(CompletableEvent.calculateDeadlineMs((long)this.time.milliseconds(), (long)timeoutMs));
        UnsubscribeEvent event2 = new UnsubscribeEvent(CompletableEvent.calculateDeadlineMs((long)this.time.milliseconds(), (long)timeoutMs));
        this.reaper.add((CompletableEvent)event1);
        this.reaper.add((CompletableEvent)event2);
        event1.future().complete(null);
        Assertions.assertEquals((int)2, (int)this.reaper.size());
        Assertions.assertEquals((long)1L, (long)this.reaper.reap(queue));
        Assertions.assertEquals((int)0, (int)this.reaper.size());
        Assertions.assertEquals((int)0, (int)queue.size());
        Assertions.assertTrue((boolean)event1.future().isDone());
        Assertions.assertNull((Object)ConsumerUtils.getResult((Future)event1.future()));
        Assertions.assertTrue((boolean)event2.future().isCompletedExceptionally());
        Assertions.assertThrows(TimeoutException.class, () -> ConsumerUtils.getResult((Future)event2.future()));
    }
}

