/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import org.apache.kafka.common.acl.AclState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AclStateTest {
    private static final AclStateTestInfo[] INFOS = new AclStateTestInfo[]{new AclStateTestInfo(AclState.UNKNOWN, 0, true), new AclStateTestInfo(AclState.ACTIVE, 1, false), new AclStateTestInfo(AclState.DELETED, 2, false), new AclStateTestInfo(AclState.ANY, 3, false)};

    @Test
    public void testIsUnknown() {
        for (AclStateTestInfo info : INFOS) {
            Assertions.assertEquals((Object)info.aclState.isUnknown(), (Object)info.unknown, (String)(info.aclState.name() + " was supposed to have unknown == " + info.unknown));
        }
    }

    @Test
    public void testCode() {
        for (AclStateTestInfo info : INFOS) {
            Assertions.assertEquals((int)info.aclState.code(), (int)info.code, (String)(info.aclState.name() + " was supposed to have code == " + info.code));
            Assertions.assertEquals((Object)info.aclState, (Object)AclState.fromCode((byte)((byte)info.code)), (String)("AclState.fromCode(" + info.code + ") was supposed to be " + String.valueOf(info.aclState)));
        }
    }

    @Test
    public void testExhaustive() {
        Assertions.assertEquals((int)INFOS.length, (int)AclState.values().length);
        for (int i = 0; i < INFOS.length; ++i) {
            Assertions.assertEquals((Object)AclStateTest.INFOS[i].aclState, (Object)AclState.values()[i]);
        }
    }

    private static class AclStateTestInfo {
        private final AclState aclState;
        private final int code;
        private final boolean unknown;

        AclStateTestInfo(AclState aclState, int code, boolean unknown) {
            this.aclState = aclState;
            this.code = code;
            this.unknown = unknown;
        }
    }
}

