/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

public class JmxReporterTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJmxRegistration() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try (Metrics metrics = new Metrics();){
            JmxReporter reporter = new JmxReporter();
            metrics.addReporter((MetricsReporter)reporter);
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Sensor sensor = metrics.sensor("kafka.requests");
            sensor.add(metrics.metricName("pack.bean1.avg", "grp1"), (MeasurableStat)new Avg());
            sensor.add(metrics.metricName("pack.bean2.total", "grp2"), (MeasurableStat)new CumulativeSum());
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Assertions.assertEquals((Object)Double.NaN, (Object)server.getAttribute(new ObjectName(":type=grp1"), "pack.bean1.avg"));
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=grp2")));
            Assertions.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=grp2"), "pack.bean2.total"));
            MetricName metricName = metrics.metricName("pack.bean1.avg", "grp1");
            String mBeanName = JmxReporter.getMBeanName((String)"", (MetricName)metricName);
            Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
            metrics.removeMetric(metricName);
            Assertions.assertFalse((boolean)reporter.containsMbean(mBeanName));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=grp2")));
            Assertions.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=grp2"), "pack.bean2.total"));
            metricName = metrics.metricName("pack.bean2.total", "grp2");
            metrics.removeMetric(metricName);
            Assertions.assertFalse((boolean)reporter.containsMbean(mBeanName));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp2")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=5)
    public void testGetMbeanInfoConcurrency() throws Exception {
        Metrics metrics = new Metrics();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2, ThreadUtils.createThreadFactory((String)"MbeanInfo", (boolean)false));
        try {
            JmxReporter reporter = new JmxReporter();
            metrics.addReporter((MetricsReporter)reporter);
            Map mbeans = (Map)TestUtils.fieldValue(reporter, JmxReporter.class, "mbeans");
            ScheduledFuture<?> mBeanInfoFuture = scheduler.scheduleAtFixedRate(() -> {
                try {
                    for (int i = 0; i < 10; ++i) {
                        MetricName metricName = metrics.metricName("pack.foo.avg" + i, "bar" + i);
                        String mBeanName = JmxReporter.getMBeanName((String)"", (MetricName)metricName);
                        DynamicMBean dynamicMBean = (DynamicMBean)mbeans.get(mBeanName);
                        if (dynamicMBean == null) continue;
                        dynamicMBean.getMBeanInfo();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, 0L, 1L, TimeUnit.MILLISECONDS);
            scheduler.scheduleAtFixedRate(() -> {
                try {
                    String mBeanName;
                    MetricName metricName;
                    int i;
                    for (i = 0; i < 10; ++i) {
                        metricName = metrics.metricName("pack.foo.avg" + i, "bar" + i);
                        mBeanName = JmxReporter.getMBeanName((String)"", (MetricName)metricName);
                        metrics.addMetric(metricName, (Measurable)new Avg());
                        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
                    }
                    for (i = 0; i < 10; ++i) {
                        metricName = metrics.metricName("pack.foo.avg" + i, "bar" + i);
                        mBeanName = JmxReporter.getMBeanName((String)"", (MetricName)metricName);
                        metrics.removeMetric(metricName);
                        Assertions.assertFalse((boolean)reporter.containsMbean(mBeanName));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, 0L, 1L, TimeUnit.MILLISECONDS);
            try {
                mBeanInfoFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        finally {
            metrics.close();
            scheduler.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJmxRegistrationSanitization() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try (Metrics metrics = new Metrics();){
            metrics.addReporter((MetricsReporter)new JmxReporter());
            Sensor sensor = metrics.sensor("kafka.requests");
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo*"}), (MeasurableStat)new CumulativeSum());
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo+"}), (MeasurableStat)new CumulativeSum());
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo?"}), (MeasurableStat)new CumulativeSum());
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo:"}), (MeasurableStat)new CumulativeSum());
            sensor.add(metrics.metricName("name", "group", "desc", new String[]{"id", "foo%"}), (MeasurableStat)new CumulativeSum());
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo\\*\"")));
            Assertions.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=\"foo\\*\""), "name"));
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo+\"")));
            Assertions.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=\"foo+\""), "name"));
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo\\?\"")));
            Assertions.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=\"foo\\?\""), "name"));
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo:\"")));
            Assertions.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=\"foo:\""), "name"));
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=group,id=foo%")));
            Assertions.assertEquals((Object)0.0, (Object)server.getAttribute(new ObjectName(":type=group,id=foo%"), "name"));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo*"}));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo+"}));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo?"}));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo:"}));
            metrics.removeMetric(metrics.metricName("name", "group", "desc", new String[]{"id", "foo%"}));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo\\*\"")));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=foo+")));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo\\?\"")));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=\"foo:\"")));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=group,id=foo%")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPredicateAndDynamicReload() throws Exception {
        Metrics metrics = new Metrics();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("metrics.jmx.exclude", JmxReporter.getMBeanName((String)"", (MetricName)metrics.metricName("pack.bean2.total", "grp2")));
        try {
            JmxReporter reporter = new JmxReporter();
            reporter.configure(configs);
            metrics.addReporter((MetricsReporter)reporter);
            Sensor sensor = metrics.sensor("kafka.requests");
            sensor.add(metrics.metricName("pack.bean2.avg", "grp1"), (MeasurableStat)new Avg());
            sensor.add(metrics.metricName("pack.bean2.total", "grp2"), (MeasurableStat)new CumulativeSum());
            sensor.record();
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Assertions.assertEquals((Object)1.0, (Object)server.getAttribute(new ObjectName(":type=grp1"), "pack.bean2.avg"));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp2")));
            sensor.record();
            configs.put("metrics.jmx.exclude", JmxReporter.getMBeanName((String)"", (MetricName)metrics.metricName("pack.bean2.avg", "grp1")));
            reporter.reconfigure(configs);
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp1")));
            Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(":type=grp2")));
            Assertions.assertEquals((Object)2.0, (Object)server.getAttribute(new ObjectName(":type=grp2"), "pack.bean2.total"));
            metrics.removeMetric(metrics.metricName("pack.bean2.total", "grp2"));
            Assertions.assertFalse((boolean)server.isRegistered(new ObjectName(":type=grp2")));
        }
        finally {
            metrics.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJmxPrefix() throws Exception {
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        MetricConfig metricConfig = new MetricConfig();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try (Metrics metrics = new Metrics(metricConfig, new ArrayList<JmxReporter>(Collections.singletonList(reporter)), Time.SYSTEM, (MetricsContext)metricsContext);){
            Sensor sensor = metrics.sensor("kafka.requests");
            sensor.add(metrics.metricName("pack.bean1.avg", "grp1"), (MeasurableStat)new Avg());
            Assertions.assertEquals((Object)"kafka.server", (Object)server.getObjectInstance(new ObjectName("kafka.server:type=grp1")).getObjectName().getDomain());
        }
    }
}

