/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.MockAsyncAuthExecutor;
import org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class PlaintextChannelBuilderTest {
    @Test
    public void testProxyModeLocalDefaultConfig() {
        ListenerName listenerName = new ListenerName("INTERNAL_TENANT_SCOPED");
        PlaintextChannelBuilder channelBuilder = new PlaintextChannelBuilder(ConnectionMode.SERVER, listenerName, new ProxyProtocolEngineFactory(ProxyProtocol.V2));
        HashMap<String, Boolean> configs = new HashMap<String, Boolean>();
        configs.put("confluent.proxy.mode.local.default", true);
        channelBuilder.configure(configs);
        KafkaChannel kafkaChannel = this.buildChannel(channelBuilder);
        boolean isProxyModeLocal = kafkaChannel.isProxyModeLocal();
        Assertions.assertTrue((boolean)isProxyModeLocal);
    }

    @Test
    public void testProxyModeProxy() {
        ListenerName listenerName = new ListenerName("INTERNAL_TENANT_SCOPED");
        ProxyProtocolV2Engine engine = (ProxyProtocolV2Engine)Mockito.mock(ProxyProtocolV2Engine.class);
        Mockito.when((Object)engine.command()).thenReturn((Object)ProxyProtocolCommand.PROXY);
        Function<ChannelMetadataRegistry, ProxyProtocolEngine> supplier = metadataRegistry -> engine;
        PlaintextChannelBuilder channelBuilder = new PlaintextChannelBuilder(ConnectionMode.SERVER, listenerName, new ProxyProtocolEngineFactory(supplier));
        HashMap<String, Boolean> configs = new HashMap<String, Boolean>();
        configs.put("confluent.proxy.mode.local.default", true);
        channelBuilder.configure(configs);
        KafkaChannel kafkaChannel = this.buildChannel(channelBuilder);
        boolean isProxyModeLocal = kafkaChannel.isProxyModeLocal();
        Assertions.assertFalse((boolean)isProxyModeLocal);
    }

    private KafkaChannel buildChannel(PlaintextChannelBuilder builder) {
        SelectionKey key = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)key.isReadable()).thenReturn((Object)true);
        SocketChannel channel = (SocketChannel)Mockito.mock(SocketChannel.class);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)key.channel()).thenReturn((Object)channel);
        Mockito.when((Object)channel.socket()).thenReturn((Object)socket);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)InetAddress.getLoopbackAddress());
        KafkaChannel kafkaChannel = builder.buildChannel("0", key, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), (MemoryPool)Mockito.mock(MemoryPool.class), (ChannelMetadataRegistry)Mockito.mock(ChannelMetadataRegistry.class), (Time)new MockTime(), (LogContext)Mockito.mock(LogContext.class));
        return kafkaChannel;
    }
}

