/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.network.ServerConnectionId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ServerConnectionIdTest {
    @Test
    public void testFromString() {
        String connectionIdString = "localhost:9092-localhost:9093-1-2";
        Optional serverConnectionIdOptional = ServerConnectionId.fromString((String)connectionIdString);
        Assertions.assertTrue((boolean)serverConnectionIdOptional.isPresent());
        ServerConnectionId serverConnectionId = (ServerConnectionId)serverConnectionIdOptional.get();
        Assertions.assertEquals((Object)"localhost", (Object)serverConnectionId.localHost());
        Assertions.assertEquals((int)9092, (int)serverConnectionId.localPort());
        Assertions.assertEquals((Object)"localhost", (Object)serverConnectionId.remoteHost());
        Assertions.assertEquals((int)9093, (int)serverConnectionId.remotePort());
        Assertions.assertEquals((int)1, (int)serverConnectionId.processorId());
        Assertions.assertEquals((int)2, (int)serverConnectionId.index());
        connectionIdString = "localhost:9092-127.0.0.1:9093-0-0";
        serverConnectionIdOptional = ServerConnectionId.fromString((String)connectionIdString);
        Assertions.assertTrue((boolean)serverConnectionIdOptional.isPresent());
        serverConnectionId = (ServerConnectionId)serverConnectionIdOptional.get();
        Assertions.assertEquals((Object)"localhost", (Object)serverConnectionId.localHost());
        Assertions.assertEquals((int)9092, (int)serverConnectionId.localPort());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)serverConnectionId.remoteHost());
        Assertions.assertEquals((int)9093, (int)serverConnectionId.remotePort());
        Assertions.assertEquals((int)0, (int)serverConnectionId.processorId());
        Assertions.assertEquals((int)0, (int)serverConnectionId.index());
        connectionIdString = "2001:db8:0:0:0:0:0:1:9092-127.0.0.1:9093-1-2";
        serverConnectionIdOptional = ServerConnectionId.fromString((String)connectionIdString);
        Assertions.assertTrue((boolean)serverConnectionIdOptional.isPresent());
        serverConnectionId = (ServerConnectionId)serverConnectionIdOptional.get();
        Assertions.assertEquals((Object)"2001:db8:0:0:0:0:0:1", (Object)serverConnectionId.localHost());
        Assertions.assertEquals((int)9092, (int)serverConnectionId.localPort());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)serverConnectionId.remoteHost());
        Assertions.assertEquals((int)9093, (int)serverConnectionId.remotePort());
        Assertions.assertEquals((int)1, (int)serverConnectionId.processorId());
        Assertions.assertEquals((int)2, (int)serverConnectionId.index());
        connectionIdString = "2002:db9:1:0:0:0:0:1:9092-2001:db8::1:9093-0-1";
        serverConnectionIdOptional = ServerConnectionId.fromString((String)connectionIdString);
        Assertions.assertTrue((boolean)serverConnectionIdOptional.isPresent());
        serverConnectionId = (ServerConnectionId)serverConnectionIdOptional.get();
        Assertions.assertEquals((Object)"2002:db9:1:0:0:0:0:1", (Object)serverConnectionId.localHost());
        Assertions.assertEquals((int)9092, (int)serverConnectionId.localPort());
        Assertions.assertEquals((Object)"2001:db8::1", (Object)serverConnectionId.remoteHost());
        Assertions.assertEquals((int)9093, (int)serverConnectionId.remotePort());
        Assertions.assertEquals((int)0, (int)serverConnectionId.processorId());
        Assertions.assertEquals((int)1, (int)serverConnectionId.index());
    }

    @Test
    public void testFromStringInvalid() {
        String connectionIdString = "localhost:9092-localhost:9093-1";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost:9092-localhost:9093-1-2-3";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost-9092-localhost:9093-1-2";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost:9092:localhost-9093-1-2";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost9092-localhost:9093-1-2";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost:9092-localhost9093-1-2";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost:abcd-localhost:9093-1-2";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost:9092-localhost:abcd-1-2";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost:9092-localhost:9093-a-2";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "localhost:9092-localhost:9093-1-b";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
        connectionIdString = "[2001:db8:0:0:0:0:0:1]:9092-127.0.0.1:9093-1-2";
        Assertions.assertFalse((boolean)ServerConnectionId.fromString((String)connectionIdString).isPresent());
    }

    @Test
    public void testGenerateConnectionId() throws IOException {
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)socket.getLocalAddress()).thenReturn((Object)InetAddress.getByName("127.0.0.1"));
        Mockito.when((Object)socket.getLocalPort()).thenReturn((Object)9092);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)InetAddress.getByName("127.0.0.1"));
        Mockito.when((Object)socket.getPort()).thenReturn((Object)9093);
        Assertions.assertEquals((Object)"127.0.0.1:9092-127.0.0.1:9093-0-0", (Object)ServerConnectionId.generateConnectionId((Socket)socket, (int)0, (int)0));
        Assertions.assertEquals((Object)"127.0.0.1:9092-127.0.0.1:9093-1-2", (Object)ServerConnectionId.generateConnectionId((Socket)socket, (int)1, (int)2));
    }

    @Test
    public void testGenerateConnectionIdIpV6() throws IOException {
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)socket.getLocalAddress()).thenReturn((Object)InetAddress.getByName("[2001:db8::1]"));
        Mockito.when((Object)socket.getLocalPort()).thenReturn((Object)9092);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)InetAddress.getByName("127.0.0.1"));
        Mockito.when((Object)socket.getPort()).thenReturn((Object)9093);
        Assertions.assertEquals((Object)"2001:db8:0:0:0:0:0:1:9092-127.0.0.1:9093-1-2", (Object)ServerConnectionId.generateConnectionId((Socket)socket, (int)1, (int)2));
        Mockito.when((Object)socket.getLocalAddress()).thenReturn((Object)InetAddress.getByName("[2002:db9:1::1]"));
        Mockito.when((Object)socket.getLocalPort()).thenReturn((Object)9092);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)InetAddress.getByName("[2001:db8::1]"));
        Mockito.when((Object)socket.getPort()).thenReturn((Object)9093);
        Assertions.assertEquals((Object)"2002:db9:1:0:0:0:0:1:9092-2001:db8:0:0:0:0:0:1:9093-1-2", (Object)ServerConnectionId.generateConnectionId((Socket)socket, (int)1, (int)2));
        Mockito.when((Object)socket.getLocalAddress()).thenReturn((Object)InetAddress.getByName("2002:db9:1::1"));
        Mockito.when((Object)socket.getLocalPort()).thenReturn((Object)9092);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)InetAddress.getByName("2001:db8::1"));
        Mockito.when((Object)socket.getPort()).thenReturn((Object)9093);
        Assertions.assertEquals((Object)"2002:db9:1:0:0:0:0:1:9092-2001:db8:0:0:0:0:0:1:9093-1-2", (Object)ServerConnectionId.generateConnectionId((Socket)socket, (int)1, (int)2));
    }

    @Test
    public void testParseHostPort() {
        Optional hostPortEntry = ServerConnectionId.parseHostPort((String)"myhost:9092");
        Assertions.assertTrue((boolean)hostPortEntry.isPresent());
        Assertions.assertEquals((Object)"myhost", ((Map.Entry)hostPortEntry.get()).getKey());
        Assertions.assertEquals((int)9092, (Integer)((Integer)((Map.Entry)hostPortEntry.get()).getValue()));
        hostPortEntry = ServerConnectionId.parseHostPort((String)"127.0.0.1:9092");
        Assertions.assertTrue((boolean)hostPortEntry.isPresent());
        Assertions.assertEquals((Object)"127.0.0.1", ((Map.Entry)hostPortEntry.get()).getKey());
        Assertions.assertEquals((int)9092, (Integer)((Integer)((Map.Entry)hostPortEntry.get()).getValue()));
        hostPortEntry = ServerConnectionId.parseHostPort((String)"2001:db8::1:9092");
        Assertions.assertTrue((boolean)hostPortEntry.isPresent());
        Assertions.assertEquals((Object)"2001:db8::1", ((Map.Entry)hostPortEntry.get()).getKey());
        Assertions.assertEquals((int)9092, (Integer)((Integer)((Map.Entry)hostPortEntry.get()).getValue()));
    }

    @Test
    public void testParseHostPortInvalid() {
        Optional hostPortEntry = ServerConnectionId.parseHostPort((String)"myhost-9092");
        Assertions.assertFalse((boolean)hostPortEntry.isPresent());
        hostPortEntry = ServerConnectionId.parseHostPort((String)"myhost9092");
        Assertions.assertFalse((boolean)hostPortEntry.isPresent());
        hostPortEntry = ServerConnectionId.parseHostPort((String)"myhost:abcd");
        Assertions.assertFalse((boolean)hostPortEntry.isPresent());
        hostPortEntry = ServerConnectionId.parseHostPort((String)"[2001:db8::1]:9092");
        Assertions.assertFalse((boolean)hostPortEntry.isPresent());
    }
}

