/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.nio.ByteBuffer;
import java.util.Map;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import org.apache.kafka.common.network.SslUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SslUtilTest {
    private static final String CLIENT_HELLO = "160303012A010001260303E1DC10EAC2C8DB51B9456C35FC6C44B0BB9C6E1FB0C5EE38707904CBF9728B14000056C02CC02BC030009DC02EC032009F00A3C02F009CC02DC031009E00A2C024C028003DC026C02A006B006AC00AC0140035C005C00F00390038C023C027003CC025C02900670040C009C013002FC004C00E0033003200FF010000A70000000E000C0000096C6F63616C686F7374000500050100000000000A0012001000170018001901000101010201030104000B00020100000D002800260403050306030804080508060809080A080B04010501060104020303030103020203020102020032002800260403050306030804080508060809080A080B04010501060104020303030103020203020102020011000900070200040000000000170000002B00030203030000000000000000";
    private static final String CLIENT_HELLO_UNPARSEABLE_SNI = "160303012A010001260303E1DC10EAC2C8DB51B9456C35FC6C44B0BB9C6E1FB0C5EE38707904CBF9728B14000056C02CC02BC030009DC02EC032009F00A3C02F009CC02DC031009E00A2C024C028003DC026C02A006B006AC00AC0140035C005C00F00390038C023C027003CC025C02900670040C009C013002FC004C00E0033003200FF010000A70000000E000C0000096E6F6E5F6C64685F686F73746E616D65000500050100000000000A0012001000170018001901000101010201030104000B00020100000D002800260403050306030804080508060809080A080B04010501060104020303030103020203020102020032002800260403050306030804080508060809080A080B04010501060104020303030103020203020102020011000900070200040000000000170000002B00030203030000000000000000";

    @Test
    public void testParseSniServerNameSuccessfully() throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(500);
        SslUtilTest.fillByteBuffer(CLIENT_HELLO, byteBuffer);
        byteBuffer.position(0);
        Map sniServerNameMap = SslUtil.parseSniServerName((ByteBuffer)byteBuffer);
        SNIServerName sniServerName = (SNIServerName)sniServerNameMap.get(0);
        if (!(sniServerName instanceof SNIHostName)) {
            Assertions.fail((String)"SNI server type incorrect.");
        }
        Assertions.assertEquals((Object)"localhost", (Object)((SNIHostName)sniServerName).getAsciiName());
    }

    @Test
    public void testUnparseableSniServerName() throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(500);
        SslUtilTest.fillByteBuffer(CLIENT_HELLO_UNPARSEABLE_SNI, byteBuffer);
        byteBuffer.position(0);
        Map sniServerNameMap = SslUtil.parseSniServerName((ByteBuffer)byteBuffer);
        SNIServerName sniServerName = (SNIServerName)sniServerNameMap.get(0);
        if (!(sniServerName instanceof SslUtil.UnknownServerName)) {
            Assertions.fail((String)"SNI server type incorrect.");
        }
    }

    private static byte hexToByte(String hexString) {
        int firstDigit = SslUtilTest.toDigit(hexString.charAt(0));
        int secondDigit = SslUtilTest.toDigit(hexString.charAt(1));
        return (byte)((firstDigit << 4) + secondDigit);
    }

    private static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }

    private static void fillByteBuffer(String hexString, ByteBuffer bf) {
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String supplied.");
        }
        for (int i = 0; i < hexString.length(); i += 2) {
            bf.put(SslUtilTest.hexToByte(hexString.substring(i, i + 2)));
        }
    }
}

