/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.SslSelectorTest;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="bazel:shard_count:2")
public class Tls12SelectorTest
extends SslSelectorTest {
    @Override
    protected Map<String, Object> createSslClientConfigs(File trustStoreFile) throws GeneralSecurityException, IOException {
        Map<String, Object> configs = TestSslUtils.createSslConfig(false, false, ConnectionMode.CLIENT, trustStoreFile, "client");
        configs.put("ssl.enabled.protocols", Collections.singletonList("TLSv1.2"));
        return configs;
    }

    @Test
    public void testRenegotiationFails() throws Exception {
        String node = "0";
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelReady(this.selector, node);
        this.selector.send(this.createSend(node, node + "-0"));
        this.selector.poll(0L);
        this.server.renegotiate();
        this.selector.send(this.createSend(node, node + "-1"));
        long expiryTime = System.currentTimeMillis() + 2000L;
        ArrayList disconnected = new ArrayList();
        while (!disconnected.contains(node) && System.currentTimeMillis() < expiryTime) {
            this.selector.poll(10L);
            disconnected.addAll(this.selector.disconnected().keySet());
        }
        Assertions.assertTrue((boolean)disconnected.contains(node), (String)"Renegotiation should cause disconnection");
    }
}

