/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.ByteBufReceive;
import org.apache.kafka.common.network.netty.ReadableByteBuf;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.RequestHeader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteBufReceiveSingleRequestBufferTest {
    private static final int MAX_RECEIVE_SIZE = 0x100000;
    private static final int REQUEST_SIZE_BYTES = 4;
    private static final short API_VERSION = 1;
    private static final ApiVersionsRequest API_VERSIONS_REQUEST = new ApiVersionsRequest.Builder().build((short)1);
    private static Send send;
    private static byte[] serializedRequest;
    private ByteBufReceive receiveBuf;

    @BeforeAll
    public static void beforeAll() throws IOException {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.API_VERSIONS, 1, "test_client_id", 100);
        send = API_VERSIONS_REQUEST.toSend(requestHeader);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)channel);
        serializedRequest = channel.buffer().array();
    }

    @BeforeEach
    public void beforeEach() {
        this.receiveBuf = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        this.receiveBuf.readFrom(Unpooled.wrappedBuffer((byte[])serializedRequest));
    }

    @AfterEach
    public void afterEach() {
        this.receiveBuf.close();
    }

    @Test
    public void testClose() {
        ByteBufReceive receive = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])serializedRequest);
        Assertions.assertEquals((int)1, (int)byteBuf.refCnt());
        receive.readFrom(byteBuf);
        Assertions.assertFalse((boolean)byteBuf.isReadable());
        receive.close();
        Assertions.assertEquals((int)1, (int)byteBuf.refCnt());
        byteBuf.release();
    }

    @Test
    public void testCloseAfterPayloadCalled() {
        ByteBufReceive receive = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])serializedRequest);
        receive.readFrom(byteBuf);
        Assertions.assertFalse((boolean)byteBuf.isReadable());
        Assertions.assertEquals((int)2, (int)byteBuf.refCnt());
        Assertions.assertEquals((int)1, (int)receive.refCnt());
        ReadableByteBuf payload = receive.payload();
        Assertions.assertEquals((int)2, (int)byteBuf.refCnt());
        Assertions.assertEquals((int)2, (int)receive.refCnt());
        payload.close();
        receive.close();
        Assertions.assertEquals((int)1, (int)byteBuf.refCnt());
        Assertions.assertEquals((int)0, (int)receive.refCnt());
        byteBuf.release();
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((long)send.size(), (long)this.receiveBuf.size());
    }

    @Test
    public void testExpectedSize() {
        Assertions.assertEquals((long)send.size(), (long)(this.receiveBuf.requestSize() + 4));
    }

    @Test
    public void testComplete() {
        Assertions.assertTrue((boolean)this.receiveBuf.complete());
    }

    @Test
    public void testBytesRead() {
        ByteBufReceive receive = new ByteBufReceive(ByteBufAllocator.DEFAULT, 0x100000);
        ByteBuf byteBuf1 = Unpooled.wrappedBuffer((byte[])serializedRequest, (int)0, (int)2);
        receive.readFrom(byteBuf1);
        Assertions.assertFalse((boolean)byteBuf1.isReadable());
        Assertions.assertEquals((int)2, (int)receive.bytesRead());
        ByteBuf byteBuf2 = Unpooled.wrappedBuffer((byte[])serializedRequest, (int)2, (int)4);
        receive.readFrom(byteBuf2);
        Assertions.assertFalse((boolean)byteBuf2.isReadable());
        Assertions.assertEquals((int)6, (int)receive.bytesRead());
        ByteBuf byteBuf3 = Unpooled.wrappedBuffer((byte[])serializedRequest, (int)6, (int)(serializedRequest.length - 6));
        Assertions.assertEquals((int)1, (int)byteBuf3.refCnt());
        receive.readFrom(byteBuf3);
        Assertions.assertFalse((boolean)byteBuf2.isReadable());
        Assertions.assertEquals((int)serializedRequest.length, (int)receive.bytesRead());
        receive.close();
        Assertions.assertEquals((int)1, (int)byteBuf1.refCnt());
        Assertions.assertEquals((int)1, (int)byteBuf2.refCnt());
        Assertions.assertEquals((int)1, (int)byteBuf3.refCnt());
        byteBuf1.release();
        byteBuf2.release();
        byteBuf3.release();
    }
}

